/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.deploy.common;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class ContainerMapperParser {
    private static String mapNodeName = "map";
    private static String sourceContainerNodeName = "sourceContainer";
    private static String targetContainerNodeName = "targetContainer";
    private static final String containerMapperFileEncoding = "CP037";
    private static final String NameAttribute = "name";

    public static Map<String, String> parseDeployRulerMapper(InputStream packageManifestInputStream) throws XMLStreamException {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        XMLEventReader eventReader4RulerMaps = null;
        HashMap<String, String> rulerMapper = new HashMap<String, String>();
        eventReader4RulerMaps = inputFactory.createXMLEventReader(packageManifestInputStream, containerMapperFileEncoding);
        String currentSourceName = null;
        String currentTargetName = null;
        while (eventReader4RulerMaps.hasNext()) {
            EndElement endElement;
            String tagName;
            XMLEvent event = eventReader4RulerMaps.nextEvent();
            if (event.isStartElement()) {
                StartElement startElement = event.asStartElement();
                tagName = startElement.getName().getLocalPart().trim();
                if (tagName.equalsIgnoreCase(mapNodeName)) {
                    currentSourceName = null;
                    currentTargetName = null;
                    continue;
                }
                if (tagName.equalsIgnoreCase(sourceContainerNodeName)) {
                    currentSourceName = ContainerMapperParser.getAttributeValue(startElement, NameAttribute);
                    continue;
                }
                if (!tagName.equalsIgnoreCase(targetContainerNodeName)) continue;
                currentTargetName = ContainerMapperParser.getAttributeValue(startElement, NameAttribute);
                continue;
            }
            if (!event.isEndElement() || !(tagName = (endElement = event.asEndElement()).getName().getLocalPart().trim()).equalsIgnoreCase(mapNodeName) || null == currentSourceName || null == currentTargetName) continue;
            rulerMapper.put(currentSourceName, currentTargetName);
            currentSourceName = null;
            currentTargetName = null;
        }
        return rulerMapper;
    }

    private static String getAttributeValue(StartElement startElement, String attributeName) {
        if (null == startElement || null == attributeName) {
            return null;
        }
        String attrValue = null;
        QName qn = new QName(attributeName);
        Attribute attribute = startElement.getAttributeByName(qn);
        if (null != attribute) {
            attrValue = attribute.getValue().trim();
        }
        return attrValue;
    }
}

