/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.packaging.common.properties;

import com.ibm.urbancode.zos.packaging.common.InputValidator;
import com.ibm.urbancode.zos.packaging.common.properties.BuztoolPropertyKeyword;
import com.ibm.urbancode.zos.packaging.common.properties.InvalidBuztoolPropertyException;
import java.util.HashSet;
import java.util.Set;

public class BuztoolPropertyValidator {
    private static final Set<String> allowedProperties = new HashSet<String>(){
        {
            for (BuztoolPropertyKeyword buztoolPropertyKeyword : BuztoolPropertyKeyword.values()) {
                this.add(buztoolPropertyKeyword.getValue().toUpperCase());
            }
        }
    };

    public static void validateProperty(String key, String value) {
        InputValidator.validateForEmpty("Buztool Property", key);
        if (BuztoolPropertyValidator.isPropertyNotStartingWithDeployTypePrefix(key) && BuztoolPropertyValidator.isPropertyNotOneOfTheAllowedProperties(key)) {
            throw new InvalidBuztoolPropertyException("Invalid Buztool Property " + key);
        }
        InputValidator.validateForEmpty("Value of Buztool Property " + key, value);
    }

    private static boolean isPropertyNotOneOfTheAllowedProperties(String key) {
        return !allowedProperties.contains(key);
    }

    private static boolean isPropertyNotStartingWithDeployTypePrefix(String key) {
        return !key.startsWith("DEPLOYTYPE.");
    }
}

