/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.deploy.xml.utils.parsers;

import com.ibm.urbancode.zos.deploy.xml.utils.parsers.XmlHelper;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class ContainerMapperParser {
    private static final String MAP_NODE_NAME = "map";
    private static final String SOURCE_CONTAINER_NODE_NAME = "sourceContainer";
    private static final String TARGET_CONTAINER_NODE_NAME = "targetContainer";
    private static final String NAME_ATTRIBUTE = "name";
    private final InputStream containerMapperInputStream;
    private final String encoding;
    private final XMLInputFactory inputFactory = XMLInputFactory.newInstance();
    private final Map<String, String> rulerMapper = new HashMap<String, String>();
    String currentSourceName = null;
    String currentTargetName = null;

    protected ContainerMapperParser(InputStream containerMapperInputStream, String encoding) {
        this.containerMapperInputStream = containerMapperInputStream;
        this.encoding = encoding;
    }

    public ContainerMapperParser(InputStream containerMapperInputStream) {
        this(containerMapperInputStream, "CP037");
    }

    public Map<String, String> parse() throws XMLStreamException {
        try (XMLEventReader eventReader4RulerMaps = null;){
            eventReader4RulerMaps = this.inputFactory.createXMLEventReader(this.containerMapperInputStream, this.encoding);
            while (eventReader4RulerMaps.hasNext()) {
                XMLEvent event = eventReader4RulerMaps.nextEvent();
                if (event.isStartElement()) {
                    this.processStartElement(event);
                    continue;
                }
                if (!event.isEndElement()) continue;
                this.processEndElement(event);
            }
        }
        return this.rulerMapper;
    }

    private void processStartElement(XMLEvent event) {
        StartElement startElement = event.asStartElement();
        String tagName = startElement.getName().getLocalPart().trim();
        if (tagName.equalsIgnoreCase(SOURCE_CONTAINER_NODE_NAME)) {
            this.currentSourceName = XmlHelper.getAttributeValue(startElement, NAME_ATTRIBUTE);
        } else if (tagName.equalsIgnoreCase(TARGET_CONTAINER_NODE_NAME)) {
            this.currentTargetName = XmlHelper.getAttributeValue(startElement, NAME_ATTRIBUTE);
        }
    }

    private void processEndElement(XMLEvent event) {
        EndElement endElement = event.asEndElement();
        String tagName = endElement.getName().getLocalPart().trim();
        if (tagName.equalsIgnoreCase(MAP_NODE_NAME)) {
            this.rulerMapper.put(this.currentSourceName, this.currentTargetName);
            this.currentSourceName = null;
            this.currentTargetName = null;
        }
    }
}

