/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.deploy.xml.utils.parsers;

import com.ibm.urbancode.zos.deploy.xml.utils.ContainerResource;
import com.ibm.urbancode.zos.deploy.xml.utils.Input;
import com.ibm.urbancode.zos.deploy.xml.utils.ManifestContainer;
import com.ibm.urbancode.zos.deploy.xml.utils.parsers.XmlHelper;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class PackageManifestParser {
    public static final String DELETED_SUFFIX = "_DELETE";
    private final String encoding;
    private final InputStream packageManifestInputStream;
    private final Map<String, ManifestContainer> deployedDatasetMap = new LinkedHashMap<String, ManifestContainer>();
    private final XMLInputFactory inputFactory = XMLInputFactory.newInstance();
    private ManifestContainer container = null;
    private String containerDeployType = null;
    private String containerType = null;
    private ContainerResource containerResource = null;
    private boolean isDeleted = false;

    protected PackageManifestParser(InputStream packageManifestInputStream, String encoding) {
        this.packageManifestInputStream = packageManifestInputStream;
        this.encoding = encoding;
    }

    public PackageManifestParser(InputStream packageManifestInputStream) {
        this(packageManifestInputStream, "CP037");
    }

    public Set<ManifestContainer> parse() throws XMLStreamException {
        try (XMLEventReader eventReader4Dataset = null;){
            eventReader4Dataset = this.inputFactory.createXMLEventReader(this.packageManifestInputStream, this.encoding);
            while (eventReader4Dataset.hasNext()) {
                XMLEvent event = eventReader4Dataset.nextEvent();
                if (event.isStartElement()) {
                    this.processStartElement(event);
                    continue;
                }
                if (!event.isEndElement()) continue;
                this.processEndElement(event);
            }
        }
        return new LinkedHashSet<ManifestContainer>(this.deployedDatasetMap.values());
    }

    private void processStartElement(XMLEvent event) {
        StartElement startElement = event.asStartElement();
        String tagName = startElement.getName().getLocalPart().trim();
        if (tagName.equalsIgnoreCase("deleted")) {
            this.isDeleted = true;
        } else if (tagName.equalsIgnoreCase("container")) {
            this.processContainerTag(startElement);
        } else if (tagName.equalsIgnoreCase("resource") && this.container != null) {
            this.processResourceTag(startElement);
        } else if (tagName.equalsIgnoreCase("property")) {
            this.processPropertyTag(startElement);
        } else if (tagName.equalsIgnoreCase("inputs")) {
            this.processInputsTag(startElement);
        } else if (tagName.equalsIgnoreCase("input")) {
            this.processInputTag(startElement);
        }
    }

    private void processContainerTag(StartElement startElement) {
        String containerNameKey;
        String containerName = XmlHelper.getAttributeValue(startElement, "name");
        String string = containerNameKey = this.isDeleted ? containerName + DELETED_SUFFIX : containerName;
        if (this.deployedDatasetMap.containsKey(containerNameKey)) {
            this.container = this.deployedDatasetMap.get(containerNameKey);
        } else {
            this.containerDeployType = XmlHelper.getAttributeValue(startElement, "deployType");
            this.containerType = XmlHelper.getAttributeValue(startElement, "type");
            this.container = new ManifestContainer(containerName);
            this.container.setType(this.containerType);
            this.container.setDeployType(this.containerDeployType);
            this.container.setSrcContainerName(containerName);
            if (this.isDeleted) {
                this.container.setDeleted();
            }
            this.deployedDatasetMap.put(containerNameKey, this.container);
        }
    }

    private void processResourceTag(StartElement startElement) {
        String memberDeployType = XmlHelper.getAttributeValue(startElement, "deployType");
        if (null == memberDeployType || memberDeployType.isEmpty()) {
            memberDeployType = this.containerDeployType;
        }
        String memberName = XmlHelper.getAttributeValue(startElement, "name");
        String memberType = XmlHelper.getAttributeValue(startElement, "type");
        this.containerResource = new ContainerResource(memberName);
        this.containerResource.setType(memberType);
        this.containerResource.setDeployType(memberDeployType);
        this.container.addContainerResource(this.containerResource);
    }

    private void processPropertyTag(StartElement startElement) {
        String propertyName = XmlHelper.getAttributeValue(startElement, "name");
        String propertyValue = XmlHelper.getAttributeValue(startElement, "value");
        if (this.containerResource != null) {
            this.containerResource.addCustomerProperty(propertyName, propertyValue);
        } else if (this.container != null) {
            this.container.addCustomerProperty(propertyName, propertyValue);
        }
    }

    private void processInputsTag(StartElement startElement) {
        String propertyUrl = XmlHelper.getAttributeValue(startElement, "url");
        if (this.containerResource != null) {
            this.containerResource.getInputs().setUrl(propertyUrl);
        } else if (this.container != null && this.containerType.equalsIgnoreCase("SEQUENTIAL")) {
            this.container.getInputs().setUrl(propertyUrl);
        }
    }

    private void processInputTag(StartElement startElement) {
        Input input = new Input(XmlHelper.getAttributeValue(startElement, "name"));
        input.setVersion(XmlHelper.getAttributeValue(startElement, "version"));
        input.setUrl(XmlHelper.getAttributeValue(startElement, "url"));
        input.setCompileType(XmlHelper.getAttributeValue(startElement, "compileType"));
        if (this.containerResource != null) {
            this.containerResource.getInputs().addInput(input);
        } else if (this.container != null && this.containerType.equalsIgnoreCase("SEQUENTIAL")) {
            this.container.getInputs().addInput(input);
        }
    }

    private void processEndElement(XMLEvent event) {
        EndElement endElement = event.asEndElement();
        String tagName = endElement.getName().getLocalPart().trim();
        if (tagName.equalsIgnoreCase("deleted")) {
            this.isDeleted = false;
        } else if (tagName.equalsIgnoreCase("container")) {
            this.container = null;
            this.containerDeployType = null;
            this.containerType = null;
        } else if (tagName.equalsIgnoreCase("resource")) {
            this.containerResource = null;
        }
    }
}

