/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.ibm.urbancode.zos.deploy.xml.utils.DeploymentHelper;
import com.ibm.urbancode.zos.deploy.xml.utils.DeploymentResultHelper;
import com.ibm.urbancode.zos.deploy.xml.utils.ManifestContainer;
import com.ibm.urbancode.zos.deploy.xml.utils.RollbackManifest;
import com.ibm.urbancode.zos.generate.artifact.info.ElementsSorter;
import com.ibm.urbancode.zos.generate.artifact.info.FilterInputs;
import com.ibm.urbancode.zos.generate.artifact.info.LoopType;
import com.ibm.urbancode.zos.generate.artifact.info.PackageManifestDownloader;
import com.ibm.urbancode.zos.generate.artifact.info.VersionInfoGenerator;
import com.urbancode.air.plugin.command.JsonInfoParser;
import com.urbancode.air.plugin.command.MultiGenerateInfoInputs;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang3.StringUtils;

public class MultiGenerateArtifactInfo {
    private final Properties outputProperties;
    private static final int ERR_CODE = 1;
    private final MultiGenerateInfoInputs pluginInputs;
    private int exitCode = 0;

    public MultiGenerateArtifactInfo(Properties inputProperties, Properties outputProperties) {
        this.pluginInputs = new MultiGenerateInfoInputs(inputProperties);
        this.outputProperties = outputProperties;
    }

    public int execute() {
        try {
            this.pluginInputs.validateInputs();
            if (!this.isVersionDeployed()) {
                this.ignoreTargetDatasetIfExist();
                this.ignoreDeployActionIfExist();
            }
            Set<ManifestContainer> packageManifestContainers = this.getPackageManifestContainers();
            Set<ManifestContainer> containersBasedOnLoopType = this.getManifestContainersBasedOnLoopType(packageManifestContainers);
            Set orderedContainers = new ElementsSorter(containersBasedOnLoopType, this.pluginInputs.getOrderBy()).sort();
            RollbackManifest rollbackManifest = this.getRollbackManifest();
            JsonInfoParser jsonInfoParser = new JsonInfoParser(this.pluginInputs);
            Map<String, FilterInputs> combinedProperties = jsonInfoParser.parse();
            for (Map.Entry<String, FilterInputs> entry : combinedProperties.entrySet()) {
                this.generateTextForProperty(orderedContainers, rollbackManifest, entry);
            }
        }
        catch (RuntimeException runtimeException) {
            System.out.println(" [Error] " + runtimeException.getMessage());
            this.exitCode = 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.exitCode = 1;
        }
        return this.exitCode;
    }

    private void generateTextForProperty(Set<ManifestContainer> orderedContainers, RollbackManifest rollbackManifest, Map.Entry<String, FilterInputs> entry) {
        this.printHeader(entry.getKey());
        VersionInfoGenerator infoGenerator = new VersionInfoGenerator(entry.getValue(), orderedContainers, rollbackManifest);
        infoGenerator.generate();
        String generatedText = StringUtils.chomp((String)infoGenerator.getText());
        this.printGeneratedTextToConsole(generatedText);
        this.outputProperties.setProperty(entry.getKey(), generatedText);
        String count = Long.toString(infoGenerator.getCount());
        this.outputProperties.setProperty(entry.getKey() + "-count", count);
    }

    private void printHeader(String propertyName) {
        System.out.println();
        System.out.println("************************************************************************************************");
        System.out.println("==> Generating version artifact information for property - " + propertyName);
        System.out.println("************************************************************************************************");
        System.out.println();
    }

    private boolean isVersionDeployed() {
        return DeploymentResultHelper.checkVersionDeployed((String)this.pluginInputs.getDeployBasePath(), (String)this.pluginInputs.getResourceId(), (String)this.pluginInputs.getComponentName(), (String)this.pluginInputs.getVersionName());
    }

    private void ignoreTargetDatasetIfExist() {
        if (!this.pluginInputs.getTargetDatasetJSON().isEmpty()) {
            System.out.println("Warning: Target Dataset Name Filter ignored because version " + this.pluginInputs.getVersionName() + " is not deployed");
            this.pluginInputs.ignoreTargetDatasetJSON();
        }
    }

    private void ignoreDeployActionIfExist() {
        if (!this.pluginInputs.getDeployActionJSON().isEmpty()) {
            System.out.println("Warning: Deployment Action Filter ignored because version " + this.pluginInputs.getVersionName() + " is not deployed");
            this.pluginInputs.ignoreDeployActionJSON();
        }
    }

    private Set<ManifestContainer> getPackageManifestContainers() throws Exception {
        if (this.isVersionDeployed()) {
            return DeploymentResultHelper.getDeployedDataSets((String)this.pluginInputs.getDeployBasePath(), (String)this.pluginInputs.getResourceId(), (String)this.pluginInputs.getComponentName(), (String)this.pluginInputs.getVersionName());
        }
        File workDir = new File(".");
        String versionWorkingDir = DeploymentHelper.getVersionDirPathInWorkingDir((String)workDir.getCanonicalPath(), (String)this.pluginInputs.getVersionName(), (String)this.pluginInputs.getResourceId());
        PackageManifestDownloader.download((String)this.pluginInputs.getComponentName(), (String)this.pluginInputs.getVersionName(), (String)versionWorkingDir);
        String versionManifestPath = DeploymentHelper.getFilePathInWorkingDir((String)workDir.getCanonicalPath(), (String)this.pluginInputs.getVersionName(), (String)this.pluginInputs.getResourceId(), (String)"packageManifest.xml");
        return DeploymentResultHelper.getNotDeployedDataSets((String)versionManifestPath);
    }

    private Set<ManifestContainer> getManifestContainersBasedOnLoopType(Set<ManifestContainer> packageManifestContainers) {
        if (LoopType.isDeleted((String)this.pluginInputs.getLoopType())) {
            return DeploymentResultHelper.getOnlyDeletedContainers(packageManifestContainers);
        }
        return DeploymentResultHelper.getOnlyDeployedContainers(packageManifestContainers);
    }

    private RollbackManifest getRollbackManifest() throws XMLStreamException, IOException {
        if (this.isRollbackManifestOperationsNeeded()) {
            return DeploymentResultHelper.getRollbackStructure((String)this.pluginInputs.getDeployBasePath(), (String)this.pluginInputs.getResourceId(), (String)this.pluginInputs.getComponentName(), (String)this.pluginInputs.getVersionName());
        }
        return new RollbackManifest();
    }

    private boolean isRollbackManifestOperationsNeeded() {
        if (!this.pluginInputs.getDeployActionJSON().isEmpty()) {
            return true;
        }
        String loopType = this.pluginInputs.getLoopType();
        return loopType.equals("DeletedMemberExcludingMissingMembers");
    }

    private void printGeneratedTextToConsole(String generatedText) {
        System.out.println();
        System.out.println("Output text:");
        System.out.println("========================================================================================================================");
        System.out.println(generatedText);
        System.out.println("========================================================================================================================");
    }
}

