/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.ibm.urbancode.zos.generate.artifact.info.DeploymentAction;
import com.ibm.urbancode.zos.generate.artifact.info.LoopType;
import com.urbancode.air.plugin.command.MissingInputException;
import java.util.Properties;

public class MultiGenerateInfoInputs {
    public static final String LOOP_TYPE = "loopType";
    public static final String ORDER_BY = "orderBy";
    public static final String DEPLOY_TYPE_NAME = "deployTypeName";
    public static final String SRC_DATASET_NAME = "srcDatasetName";
    public static final String DATASET_NAME = "datasetName";
    public static final String MEMBER_NAME = "memberName";
    public static final String CUST_PROPERTIES = "custProperties";
    public static final String TEMPLATE_TEXT = "templateText";
    public static final String IGNORE_UNRESOLVED = "ignoreUnresolved";
    public static final String DEPLOY_ACTION = "deployAction";
    public static final String DEPLOY_BASE_PATH = "deployBasePath";
    public static final String COMPONENT_NAME = "componentName";
    public static final String VERSION_NAME = "versionName";
    public static final String RESOURCE_ID = "resourceId";
    private final String loopType;
    private final String orderBy;
    private final String deployTypeJSON;
    private final String sourceDatasetJSON;
    private String targetDatasetJSON;
    private final String memberJSON;
    private final String customPropertiesJSON;
    private final String templateJSON;
    private final boolean ignoreUnresolved;
    private String deployActionJSON;
    private final String deployBasePath;
    private final String componentName;
    private final String versionName;
    private final String resourceId;

    public MultiGenerateInfoInputs(Properties inputProperties) {
        this.loopType = inputProperties.getProperty(LOOP_TYPE);
        this.orderBy = inputProperties.getProperty(ORDER_BY);
        this.sourceDatasetJSON = inputProperties.getProperty(SRC_DATASET_NAME).trim();
        this.targetDatasetJSON = inputProperties.getProperty(DATASET_NAME).trim();
        this.memberJSON = inputProperties.getProperty(MEMBER_NAME).trim();
        this.deployTypeJSON = inputProperties.getProperty(DEPLOY_TYPE_NAME).trim();
        this.customPropertiesJSON = inputProperties.getProperty(CUST_PROPERTIES).trim();
        this.templateJSON = inputProperties.getProperty(TEMPLATE_TEXT).trim();
        this.ignoreUnresolved = Boolean.parseBoolean(inputProperties.getProperty(IGNORE_UNRESOLVED));
        this.deployActionJSON = inputProperties.getProperty(DEPLOY_ACTION).trim();
        this.deployBasePath = inputProperties.getProperty(DEPLOY_BASE_PATH).trim();
        this.componentName = inputProperties.getProperty(COMPONENT_NAME).trim();
        this.versionName = inputProperties.getProperty(VERSION_NAME).trim();
        this.resourceId = inputProperties.getProperty(RESOURCE_ID).trim();
    }

    public void validateInputs() {
        this.checkIfEmpty(this.componentName, "Component Name");
        this.checkIfEmpty(this.deployBasePath, "Deploy Base Path");
        this.checkIfEmpty(this.versionName, "Version Name");
        this.checkIfEmpty(this.resourceId, "Resource Id");
        this.checkIfEmpty(this.templateJSON, "Template JSON");
        if (!this.deployActionJSON.isEmpty()) {
            this.validateLoopType();
        }
        if (!this.targetDatasetJSON.isEmpty() && !LoopType.isDatasetLevel((String)this.loopType)) {
            throw new IllegalArgumentException("Target Dataset Filter JSON is applicable for only dataset/member loop types.");
        }
    }

    private void validateLoopType() {
        if (DeploymentAction.isUnsupportedLoopType((String)this.loopType)) {
            throw new IllegalArgumentException("Unsupported Loop Type '" + this.loopType + "' found with deployment action. Deployment Action is supported for Loop Types - 'Sequential' or 'PDS Member'");
        }
    }

    private void checkIfEmpty(String inputValue, String inputName) {
        if (inputValue.isEmpty()) {
            throw new MissingInputException(inputName + " cannot be empty.");
        }
    }

    public String getLoopType() {
        return this.loopType;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public String getDeployTypeJSON() {
        return this.deployTypeJSON;
    }

    public String getSourceDatasetJSON() {
        return this.sourceDatasetJSON;
    }

    public String getTargetDatasetJSON() {
        return this.targetDatasetJSON;
    }

    public String getMemberJSON() {
        return this.memberJSON;
    }

    public String getCustomPropertiesJSON() {
        return this.customPropertiesJSON;
    }

    public String getTemplateJSON() {
        return this.templateJSON;
    }

    public boolean isIgnoreUnresolved() {
        return this.ignoreUnresolved;
    }

    public String getDeployActionJSON() {
        return this.deployActionJSON;
    }

    public String getDeployBasePath() {
        return this.deployBasePath;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void ignoreTargetDatasetJSON() {
        this.targetDatasetJSON = "";
    }

    public void ignoreDeployActionJSON() {
        this.deployActionJSON = "";
    }
}

