/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.generate.artifact.info;

import com.ibm.urbancode.zos.deploy.xml.utils.ContainerResource;
import com.ibm.urbancode.zos.deploy.xml.utils.ManifestContainer;
import com.ibm.urbancode.zos.deploy.xml.utils.RollbackManifest;
import com.ibm.urbancode.zos.generate.artifact.info.Console;
import com.ibm.urbancode.zos.generate.artifact.info.FilterHelper;
import com.ibm.urbancode.zos.generate.artifact.info.FilterInputs;
import com.ibm.urbancode.zos.generate.artifact.info.LoopType;
import com.ibm.urbancode.zos.generate.artifact.info.TemplateTokens;
import com.ibm.urbancode.zos.generate.artifact.info.TokenReplacer;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class VersionInfoGenerator {
    private static final String REGEX_FOR_PROPERTY = "\\$\\{.+}";
    private final FilterInputs filterInputs;
    private final Stream<ManifestContainer> containers;
    private final StringBuilder stringBuilder = new StringBuilder();
    private final FilterHelper filterHelper;
    private long count = 0L;

    public VersionInfoGenerator(FilterInputs filterInputs, Stream<ManifestContainer> containers, RollbackManifest rollbackManifest) {
        this.filterInputs = filterInputs;
        this.containers = containers;
        this.filterHelper = new FilterHelper(filterInputs, rollbackManifest);
    }

    public void generate() {
        this.filterInputs.printFilterInputs();
        if (LoopType.isContainerLevel(this.filterInputs.getLoopType())) {
            this.generateTextForContainers();
        } else {
            this.generateTextForContainerResources();
        }
    }

    private void generateTextForContainers() {
        this.count = this.containers.peek(Console::printContainerInfo).filter(this.filterHelper::isLoopTypeMatched).filter(this.filterHelper::isDeployActionMatched).filter(this.filterHelper::isTargetMatched).filter(this.filterHelper::isSourceMatched).filter(this.filterHelper::isContainerDeployTypeMatched).filter(this.filterHelper::areContainerCustomPropertiesMatched).map(TemplateTokens::get).map(this::createTemplateText).peek(this::appendText).count();
    }

    private void generateTextForContainerResources() {
        this.containers.forEach(container -> {
            Stream<ContainerResource> orderedResources = this.filterHelper.getOrderedResources(container.getContainerResources());
            this.count += this.generateTextForResource((ManifestContainer)container, orderedResources);
        });
    }

    private long generateTextForResource(ManifestContainer container, Stream<ContainerResource> resources) {
        return resources.peek(resource -> this.loadContainerProperties(container, (ContainerResource)resource)).peek(resource -> Console.printResourceInfo(container, resource)).filter(resource -> this.filterHelper.isLoopTypeMatched(container)).filter(resource -> this.filterHelper.isResourceDeployActionMatched(container, (ContainerResource)resource)).filter(resource -> this.filterHelper.isDeletedMissingMemberToBeIncluded(container, (ContainerResource)resource)).filter(resource -> this.filterHelper.isTargetMatched(container)).filter(resource -> this.filterHelper.isSourceMatched(container)).filter(this.filterHelper::isNotMissingDeletedMember).filter(this.filterHelper::isResourceDeployTypeMatched).filter(this.filterHelper::isMemberMatched).filter(this.filterHelper::areResourceCustomPropertiesMatched).map(resource -> TemplateTokens.get(container, resource)).map(this::createTemplateText).peek(this::appendText).count();
    }

    private void loadContainerProperties(ManifestContainer container, ContainerResource resource) {
        resource.getCustomerProperties().putAll(container.getCustomerProperties());
    }

    private String createTemplateText(Map<String, String> replaceTokens) {
        String templateText = TokenReplacer.replace(this.filterInputs.getTemplate(), replaceTokens);
        if (this.filterInputs.isIgnoreUnresolved()) {
            return templateText;
        }
        if (this.unresolvedPropertyExist(templateText)) {
            throw new IllegalArgumentException("Found unresolved property in template:" + templateText);
        }
        return templateText;
    }

    private boolean unresolvedPropertyExist(String text) {
        Pattern pattern = Pattern.compile(REGEX_FOR_PROPERTY);
        Matcher matcher = pattern.matcher(text);
        return matcher.find();
    }

    private void appendText(String resolvedTemplate) {
        this.stringBuilder.append(resolvedTemplate);
    }

    public String getText() {
        return this.stringBuilder.toString();
    }

    public long getCount() {
        return this.count;
    }
}

