/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.deploy.xml.utils.parsers;

import com.ibm.urbancode.zos.deploy.xml.utils.ContainerResource;
import com.ibm.urbancode.zos.deploy.xml.utils.RollbackManifest;
import com.ibm.urbancode.zos.deploy.xml.utils.RollbackManifestContainer;
import com.ibm.urbancode.zos.deploy.xml.utils.parsers.XmlHelper;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class RollbackManifestParser {
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String CONTAINER_TYPE_PDS_VALUE = "PDS";
    private static final String CONTAINER_TYPE_SEQ_VALUE = "sequential";
    private static final String CREATED_TAG = "created";
    private static final String UPDATED_TAG = "updated";
    private static final String DELETED_TAG = "deleted";
    private static final String CONTAINER_TAG = "container";
    private static final String RESOURCE_TAG = "resource";
    private static final String MISSING_ATTRIBUTE = "missing";
    private final RollbackManifest rollbackManifest = new RollbackManifest();
    private Map<String, RollbackManifestContainer> datasetMap = new HashMap<String, RollbackManifestContainer>();
    private Set<RollbackManifestContainer> containers = new HashSet<RollbackManifestContainer>();
    private RollbackManifestContainer container = null;
    private String actionName = null;
    private boolean isInsideActionTag = false;
    private boolean isInsidePDSContainer = false;
    private final InputStream rollbackInputStream;

    public RollbackManifestParser(InputStream rollbackInputStream) {
        this.rollbackInputStream = rollbackInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RollbackManifest parse() throws XMLStreamException {
        XMLInputFactory inputFactory = XMLInputFactory.newFactory();
        try (XMLStreamReader xmlStreamReader = null;){
            xmlStreamReader = inputFactory.createXMLStreamReader(this.rollbackInputStream, XmlHelper.getFileEncoding());
            while (xmlStreamReader.hasNext()) {
                int next = xmlStreamReader.next();
                if (next == 1) {
                    this.processStartElement(xmlStreamReader);
                    continue;
                }
                if (next != 2) continue;
                this.processEndElement(xmlStreamReader);
            }
        }
        return this.rollbackManifest;
    }

    private void processStartElement(XMLStreamReader xmlStreamReader) {
        String nodeName = xmlStreamReader.getLocalName().trim();
        if (this.isActionTag(nodeName)) {
            this.isInsideActionTag = true;
            this.actionName = nodeName;
        } else if (this.isInsideActionTag) {
            if (CONTAINER_TAG.equalsIgnoreCase(nodeName)) {
                this.processContainerTag(xmlStreamReader);
            } else if (RESOURCE_TAG.equalsIgnoreCase(nodeName) && this.isInsidePDSContainer) {
                this.processResourceTag(xmlStreamReader);
            }
        }
    }

    private void processContainerTag(XMLStreamReader xmlStreamReader) {
        String containerType = XmlHelper.getAttributeValue(xmlStreamReader, TYPE_ATTRIBUTE);
        String containerName = XmlHelper.getAttributeValue(xmlStreamReader, NAME_ATTRIBUTE);
        if (containerType == null) {
            throw new RuntimeException("Type not found for container " + containerName);
        }
        if (containerType.equalsIgnoreCase(CONTAINER_TYPE_PDS_VALUE)) {
            this.isInsidePDSContainer = true;
            this.container = this.datasetMap.getOrDefault(containerName, new RollbackManifestContainer(containerName));
            this.container.setType(containerType);
        } else {
            this.isInsidePDSContainer = false;
            if (containerType.equalsIgnoreCase(CONTAINER_TYPE_SEQ_VALUE)) {
                this.container = new RollbackManifestContainer(containerName);
                this.container.setType(containerType);
                if (this.isInsideDeletedActionTag() && this.hasMissingAttribute(xmlStreamReader)) {
                    this.container.setMissing();
                }
                this.containers.add(this.container);
            }
        }
    }

    private void processResourceTag(XMLStreamReader xmlStreamReader) {
        String resourceName = XmlHelper.getAttributeValue(xmlStreamReader, NAME_ATTRIBUTE);
        ContainerResource resource = new ContainerResource(resourceName);
        if (this.isInsideDeletedActionTag() && this.hasMissingAttribute(xmlStreamReader)) {
            resource.setMissing();
        }
        this.container.addEntryToResourceMap(resource);
    }

    private void processEndElement(XMLStreamReader xmlStreamReader) {
        String endNodeName = xmlStreamReader.getLocalName().trim();
        if (this.isActionTag(endNodeName)) {
            this.setContainersBasedOnAction();
            this.actionName = null;
            this.isInsideActionTag = false;
            this.isInsidePDSContainer = false;
            this.datasetMap = new HashMap<String, RollbackManifestContainer>();
            this.containers = new HashSet<RollbackManifestContainer>();
            this.container = null;
        } else if (CONTAINER_TAG.equalsIgnoreCase(endNodeName)) {
            if (this.isInsidePDSContainer) {
                this.containers.add(this.container);
                this.datasetMap.put(this.container.getName(), this.container);
                this.isInsidePDSContainer = false;
            }
            this.container = null;
        }
    }

    private void setContainersBasedOnAction() {
        if (this.actionName.equalsIgnoreCase(CREATED_TAG)) {
            this.rollbackManifest.addEntriesToCreatedContainersMap(this.containers);
        } else if (this.actionName.equalsIgnoreCase(UPDATED_TAG)) {
            this.rollbackManifest.addEntriesToUpdatedContainersMap(this.containers);
        } else {
            this.rollbackManifest.addEntriesToDeletedContainersMap(this.containers);
        }
    }

    private boolean isActionTag(String nodeName) {
        return CREATED_TAG.equalsIgnoreCase(nodeName) || UPDATED_TAG.equalsIgnoreCase(nodeName) || DELETED_TAG.equalsIgnoreCase(nodeName);
    }

    private boolean isInsideDeletedActionTag() {
        return DELETED_TAG.equalsIgnoreCase(this.actionName);
    }

    private boolean hasMissingAttribute(XMLStreamReader xmlStreamReader) {
        return Boolean.parseBoolean(XmlHelper.getAttributeValue(xmlStreamReader, MISSING_ATTRIBUTE));
    }
}

