/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.ibm.urbancode.zos.generate.artifact.info.DeploymentAction;
import com.ibm.urbancode.zos.generate.artifact.info.FilterInputs;
import com.ibm.urbancode.zos.generate.artifact.info.Filters;
import com.ibm.urbancode.zos.generate.artifact.info.utils.CustomPropertiesParser;
import com.urbancode.air.plugin.command.MissingInputException;
import com.urbancode.air.plugin.command.MultiGenerateInfoInputs;
import java.util.Map;
import java.util.stream.Collectors;

public class JsonInfoParser {
    private static final String TEMPLATE_JSON = "Template JSON";
    private static final String CONTAINER_NAME_FILTER_JSON = "Container Name filter JSON";
    private static final String TARGET_NAME_FILTER_JSON = "Target Name filter JSON";
    private static final String RESOURCE_NAME_FILTER_JSON = "Resource Name filter JSON";
    private static final String DEPLOY_TYPE_FILTER_JSON = "Deploy Type filter JSON";
    private static final String CUSTOM_PROPERTIES_FILTER_JSON = "Custom properties filter JSON";
    private static final String DEPLOYMENT_ACTION_FILTER_JSON = "Deployment action filter JSON";
    private static final String EMPTY_STRING = "";
    private final JsonObject sourceContainerJson;
    private final JsonObject targetContainerJson;
    private final JsonObject resourceJson;
    private final JsonObject deployTypeJson;
    private final JsonObject customPropertiesJson;
    private final JsonObject deployActionJson;
    private final JsonObject templateJson;
    private final MultiGenerateInfoInputs pluginInputs;

    public JsonInfoParser(MultiGenerateInfoInputs pluginInputs) {
        this.pluginInputs = pluginInputs;
        this.templateJson = this.getJsonObject(pluginInputs.getTemplateJSON(), TEMPLATE_JSON);
        this.sourceContainerJson = this.getJsonObject(pluginInputs.getSourceDatasetJSON(), CONTAINER_NAME_FILTER_JSON);
        this.targetContainerJson = this.getJsonObject(pluginInputs.getTargetDatasetJSON(), TARGET_NAME_FILTER_JSON);
        this.resourceJson = this.getJsonObject(pluginInputs.getMemberJSON(), RESOURCE_NAME_FILTER_JSON);
        this.deployTypeJson = this.getJsonObject(pluginInputs.getDeployTypeJSON(), DEPLOY_TYPE_FILTER_JSON);
        this.customPropertiesJson = this.getJsonObject(pluginInputs.getCustomPropertiesJSON(), CUSTOM_PROPERTIES_FILTER_JSON);
        this.deployActionJson = this.getJsonObject(pluginInputs.getDeployActionJSON(), DEPLOYMENT_ACTION_FILTER_JSON);
    }

    public Map<String, Filters> parse() {
        return this.templateJson.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, this::getFilterInputs));
    }

    private Filters getFilterInputs(Map.Entry<String, JsonElement> entry) {
        String template = entry.getValue().getAsString();
        this.validateTemplate(entry.getKey(), template);
        FilterInputs filterInputs = new FilterInputs(this.pluginInputs.getLoopType(), template);
        if (this.pluginInputs.isIgnoreUnresolved()) {
            filterInputs.setIgnoreUnresolved();
        }
        filterInputs.setSourceContainer(this.getValue(this.sourceContainerJson, entry.getKey()));
        filterInputs.setTargetDataset(this.getValue(this.targetContainerJson, entry.getKey()));
        filterInputs.setResource(this.getValue(this.resourceJson, entry.getKey()));
        filterInputs.setDeployType(this.getValue(this.deployTypeJson, entry.getKey()));
        String customPropertyLines = this.getValue(this.customPropertiesJson, entry.getKey());
        Map customPropertiesMap = CustomPropertiesParser.parseIntoMap((String)customPropertyLines);
        filterInputs.setCustomProperties(customPropertiesMap);
        String deploymentActionValue = this.getValue(this.deployActionJson, entry.getKey()).trim();
        if (!deploymentActionValue.isEmpty()) {
            DeploymentAction deploymentAction = this.convertToEnum(entry.getKey(), deploymentActionValue);
            filterInputs.setDeploymentAction(deploymentAction);
        }
        return filterInputs;
    }

    private DeploymentAction convertToEnum(String propertyName, String deploymentActionValue) {
        try {
            return DeploymentAction.valueOf((String)deploymentActionValue.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("ERROR: Invalid value '" + deploymentActionValue + "' has been assigned to property '" + propertyName + "' in Deployment Action Filter input. Action value can be either 'created' or 'updated'.");
        }
    }

    private void validateTemplate(String propertyKey, String template) {
        if (template.trim().isEmpty()) {
            throw new MissingInputException("Template JSON does not contain value for property '" + propertyKey + "'");
        }
    }

    private JsonObject getJsonObject(String jsonString, String name) {
        if (jsonString.isEmpty()) {
            return new JsonObject();
        }
        Gson gson = new Gson();
        try {
            JsonElement element = gson.fromJson(jsonString, JsonElement.class);
            return element.getAsJsonObject();
        }
        catch (JsonSyntaxException e) {
            System.out.println("Error while processing JSON for '" + name + "'");
            throw e;
        }
    }

    private String getValue(JsonObject jsonObject, String key) {
        if (jsonObject.has(key)) {
            return jsonObject.get(key).getAsString();
        }
        return EMPTY_STRING;
    }
}

