/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.xml.utils.rollback;

import com.ibm.urbancode.zos.xml.utils.common.ContainerType;
import com.ibm.urbancode.zos.xml.utils.common.XmlHelper;
import com.ibm.urbancode.zos.xml.utils.rollback.RollbackContainer;
import com.ibm.urbancode.zos.xml.utils.rollback.RollbackResource;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

class ActionNode {
    private final Map<String, RollbackContainer> datasetMap = new LinkedHashMap<String, RollbackContainer>();
    private final Map<String, RollbackContainer> directoryMap = new LinkedHashMap<String, RollbackContainer>();
    private RollbackContainer rollbackContainer = null;
    private boolean isEndOfActionTag = false;
    private final String actionName;

    private ActionNode(String actionName) {
        this.actionName = actionName;
    }

    public static List<RollbackContainer> getContainers(XMLStreamReader xmlStreamReader, String actionName) throws XMLStreamException {
        ActionNode actionNode = new ActionNode(actionName);
        actionNode.processRollbackContainers(xmlStreamReader);
        return actionNode.getRollbackContainers();
    }

    private void processRollbackContainers(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        while (!this.isEndOfActionTag && xmlStreamReader.hasNext()) {
            int next = xmlStreamReader.next();
            if (next == 1) {
                this.processStartElement(xmlStreamReader);
                continue;
            }
            if (next != 2) continue;
            this.processEndElement(xmlStreamReader);
        }
    }

    private void processStartElement(XMLStreamReader xmlStreamReader) {
        String nodeName = xmlStreamReader.getLocalName().trim();
        if ("container".equalsIgnoreCase(nodeName)) {
            this.processContainerTag(xmlStreamReader);
        } else if ("resource".equalsIgnoreCase(nodeName)) {
            this.processResourceTag(xmlStreamReader);
        }
    }

    private void processContainerTag(XMLStreamReader xmlStreamReader) {
        String containerName = XmlHelper.getAttributeValue(xmlStreamReader, "name");
        ContainerType containerType = XmlHelper.getContainerType(xmlStreamReader, containerName);
        if (containerType == ContainerType.PDS && this.datasetMap.containsKey(containerName)) {
            this.rollbackContainer = this.datasetMap.get(containerName);
        } else if (containerType == ContainerType.DIRECTORY && this.directoryMap.containsKey(containerName)) {
            this.rollbackContainer = this.directoryMap.get(containerName);
        } else {
            this.rollbackContainer = new RollbackContainer(containerName, containerType);
            if (this.hasMissingAttribute(xmlStreamReader)) {
                this.rollbackContainer.setMissing();
            }
        }
    }

    private void processResourceTag(XMLStreamReader xmlStreamReader) {
        String resourceName = XmlHelper.getAttributeValue(xmlStreamReader, "name");
        String resourceType = XmlHelper.getAttributeValue(xmlStreamReader, "type");
        RollbackResource resource = new RollbackResource(resourceName, resourceType);
        if (this.rollbackContainer.isMissing() || this.hasMissingAttribute(xmlStreamReader)) {
            resource.setMissing();
        }
        this.rollbackContainer.addResource(resource);
    }

    private void processEndElement(XMLStreamReader xmlStreamReader) {
        String endNodeName = xmlStreamReader.getLocalName().trim();
        if ("container".equalsIgnoreCase(endNodeName)) {
            this.processEndContainerTag();
        } else if (endNodeName.equalsIgnoreCase(this.actionName)) {
            this.isEndOfActionTag = true;
        }
    }

    private void processEndContainerTag() {
        if (this.rollbackContainer.getType() == ContainerType.DIRECTORY) {
            this.directoryMap.put(this.rollbackContainer.getName(), this.rollbackContainer);
        } else {
            this.datasetMap.put(this.rollbackContainer.getName(), this.rollbackContainer);
        }
        this.rollbackContainer = null;
    }

    private List<RollbackContainer> getRollbackContainers() {
        ArrayList<RollbackContainer> containers = new ArrayList<RollbackContainer>();
        containers.addAll(this.datasetMap.values());
        containers.addAll(this.directoryMap.values());
        return containers;
    }

    private boolean hasMissingAttribute(XMLStreamReader xmlStreamReader) {
        return Boolean.parseBoolean(XmlHelper.getAttributeValue(xmlStreamReader, "missing"));
    }
}

