/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.xml.utils.rollback;

import com.ibm.urbancode.zos.xml.utils.common.ContainerType;
import com.ibm.urbancode.zos.xml.utils.rollback.RollbackResource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class RollbackContainer {
    private final List<RollbackResource> resources = new ArrayList<RollbackResource>();
    private Map<String, RollbackResource> resourceMap = null;
    private boolean isMissing;
    private final String name;
    private final ContainerType type;

    RollbackContainer(String name, ContainerType type) {
        this.name = name;
        this.type = type;
    }

    void addResource(RollbackResource resource) {
        this.resources.add(resource);
    }

    public List<RollbackResource> getResources() {
        return Collections.unmodifiableList(this.resources);
    }

    public Map<String, RollbackResource> getResourceMap() {
        if (this.resourceMap == null) {
            this.resourceMap = this.createResourceMap();
        }
        return this.resourceMap;
    }

    private Map<String, RollbackResource> createResourceMap() {
        return this.resources.stream().collect(Collectors.toMap(RollbackResource::getName, resource -> resource));
    }

    public String getName() {
        return this.name;
    }

    public ContainerType getType() {
        return this.type;
    }

    void setMissing() {
        this.isMissing = true;
    }

    public boolean isMissing() {
        return this.isMissing;
    }
}

