/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.xml.utils.deploy;

import com.ibm.urbancode.zos.xml.utils.common.ContainerType;
import com.ibm.urbancode.zos.xml.utils.common.XmlHelper;
import com.ibm.urbancode.zos.xml.utils.common.XmlIndentHandler;
import com.ibm.urbancode.zos.xml.utils.deploy.Container;
import com.ibm.urbancode.zos.xml.utils.deploy.Input;
import com.ibm.urbancode.zos.xml.utils.deploy.Inputs;
import com.ibm.urbancode.zos.xml.utils.deploy.PackageManifest;
import com.ibm.urbancode.zos.xml.utils.deploy.Resource;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

class PackageManifestXml {
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final String XML_VERSION = "1.0";
    private final XmlIndentHandler xmlIndentHandler = new XmlIndentHandler();
    private XMLStreamWriter xmlStreamWriter = null;

    private PackageManifestXml() {
    }

    public static String from(PackageManifest packageManifest) throws XMLStreamException {
        PackageManifestXml packageManifestXml = new PackageManifestXml();
        return packageManifestXml.createXML(packageManifest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createXML(PackageManifest packageManifest) throws XMLStreamException {
        StringWriter stringWriter = new StringWriter();
        XMLOutputFactory outputFactory = XMLOutputFactory.newFactory();
        try {
            this.xmlStreamWriter = outputFactory.createXMLStreamWriter(stringWriter);
            this.writeXmlElements(packageManifest);
        }
        finally {
            if (this.xmlStreamWriter != null) {
                this.xmlStreamWriter.close();
            }
        }
        return stringWriter.toString();
    }

    private void writeXmlElements(PackageManifest packageManifest) throws XMLStreamException {
        this.xmlStreamWriter.writeStartDocument(XmlHelper.getFileEncoding(), XML_VERSION);
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
        this.writeStartingManifestTag(packageManifest);
        this.writeDeployedContainers(packageManifest.getAddedContainers());
        if (!packageManifest.getDeletedContainers().isEmpty()) {
            this.writeDeletedContainers(packageManifest.getDeletedContainers());
        }
        this.xmlStreamWriter.writeEndElement();
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
        this.xmlStreamWriter.writeEndDocument();
    }

    private void writeStartingManifestTag(PackageManifest packageManifest) throws XMLStreamException {
        this.xmlStreamWriter.writeStartElement("manifest");
        if (packageManifest.getManifestType() != null) {
            this.xmlStreamWriter.writeAttribute("type", packageManifest.getManifestType());
        }
        if (packageManifest.getTimeZone() != null) {
            this.xmlStreamWriter.writeAttribute("timeZone", packageManifest.getTimeZone());
        }
        if (packageManifest.getVersion() != null) {
            this.xmlStreamWriter.writeAttribute("version", packageManifest.getVersion());
        }
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
    }

    private void writeDeployedContainers(List<Container> deployedContainers) throws XMLStreamException {
        for (Container container : deployedContainers) {
            this.writeContainerStartElement(container);
            for (Resource resource : container.getResources()) {
                this.writeContainerResource(resource);
            }
            this.writeEndElement();
        }
    }

    private void writeDeletedContainers(List<Container> deletedContainers) throws XMLStreamException {
        this.xmlStreamWriter.writeCharacters(this.xmlIndentHandler.getStartingTagIndent());
        this.xmlStreamWriter.writeStartElement("deleted");
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
        for (Container deletedContainer : deletedContainers) {
            this.writeDeletedContainer(deletedContainer);
        }
        this.writeEndElement();
    }

    private void writeDeletedContainer(Container deletedContainer) throws XMLStreamException {
        this.writeContainerStartElement(deletedContainer);
        for (Resource resource : deletedContainer.getResources()) {
            this.writeContainerResource(resource);
        }
        this.writeEndElement();
    }

    private void writeContainerStartElement(Container container) throws XMLStreamException {
        this.xmlStreamWriter.writeCharacters(this.xmlIndentHandler.getStartingTagIndent());
        this.xmlStreamWriter.writeStartElement("container");
        this.xmlStreamWriter.writeAttribute("name", container.getSourceContainerName());
        this.xmlStreamWriter.writeAttribute("type", this.getContainerType(container.getType()));
        if (container.getCopyType() != null) {
            this.xmlStreamWriter.writeAttribute("copyType", container.getCopyType().toString());
        }
        if (container.getDeployType() != null) {
            this.xmlStreamWriter.writeAttribute("deployType", container.getDeployType());
        }
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
        if (!container.getCustomerProperties().isEmpty()) {
            this.writePropertyTags(container.getCustomerProperties());
        }
        if (container.getInputs() != null) {
            this.writeInputsTag(container.getInputs());
        }
    }

    private void writeContainerResource(Resource resource) throws XMLStreamException {
        if (resource.getCustomerProperties().isEmpty() && resource.getInputs() == null) {
            this.xmlStreamWriter.writeCharacters(this.xmlIndentHandler.getSelfClosingTagIndent());
            this.xmlStreamWriter.writeEmptyElement("resource");
            this.writeResourceTagAttributes(resource);
        } else {
            this.xmlStreamWriter.writeCharacters(this.xmlIndentHandler.getStartingTagIndent());
            this.xmlStreamWriter.writeStartElement("resource");
            this.writeResourceTagAttributes(resource);
            if (!resource.getCustomerProperties().isEmpty()) {
                this.writePropertyTags(resource.getCustomerProperties());
            }
            if (resource.getInputs() != null) {
                this.writeInputsTag(resource.getInputs());
            }
            this.writeEndElement();
        }
    }

    private void writeInputsTag(Inputs resourceInputs) throws XMLStreamException {
        this.xmlStreamWriter.writeCharacters(this.xmlIndentHandler.getStartingTagIndent());
        this.xmlStreamWriter.writeStartElement("inputs");
        this.xmlStreamWriter.writeAttribute("url", resourceInputs.getUrl());
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
        for (Input input : resourceInputs.getInputs()) {
            this.xmlStreamWriter.writeCharacters(this.xmlIndentHandler.getSelfClosingTagIndent());
            this.xmlStreamWriter.writeEmptyElement("input");
            this.xmlStreamWriter.writeAttribute("name", input.getName());
            if (!input.getVersion().isEmpty()) {
                this.xmlStreamWriter.writeAttribute("version", input.getVersion());
            }
            if (!input.getCompileType().isEmpty()) {
                this.xmlStreamWriter.writeAttribute("compileType", input.getCompileType());
            }
            if (!input.getUrl().isEmpty()) {
                this.xmlStreamWriter.writeAttribute("url", input.getUrl());
            }
            this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
        }
        this.writeEndElement();
    }

    private void writePropertyTags(Map<String, String> properties) throws XMLStreamException {
        for (String propertyKey : properties.keySet()) {
            this.xmlStreamWriter.writeCharacters(this.xmlIndentHandler.getSelfClosingTagIndent());
            this.xmlStreamWriter.writeEmptyElement("property");
            this.xmlStreamWriter.writeAttribute("name", propertyKey);
            this.xmlStreamWriter.writeAttribute("value", properties.get(propertyKey));
            this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
        }
    }

    private void writeResourceTagAttributes(Resource resource) throws XMLStreamException {
        this.xmlStreamWriter.writeAttribute("name", resource.getName());
        this.xmlStreamWriter.writeAttribute("type", resource.getType());
        if (resource.getResourceDeployType() != null) {
            this.xmlStreamWriter.writeAttribute("deployType", resource.getResourceDeployType());
        }
        if (resource.getLastModifiedTimestamp() != null) {
            this.xmlStreamWriter.writeAttribute("lastModifiedTimestamp", resource.getLastModifiedTimestamp());
        }
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
    }

    private String getContainerType(ContainerType type) {
        switch (type) {
            case PDS: {
                return "PDS";
            }
            case SEQUENTIAL: {
                return "sequential";
            }
            case DIRECTORY: {
                return "directory";
            }
        }
        throw new IllegalArgumentException("Unsupported Container Type found " + (Object)((Object)type));
    }

    private void writeEndElement() throws XMLStreamException {
        this.xmlStreamWriter.writeCharacters(this.xmlIndentHandler.getEndingTagIndent());
        this.xmlStreamWriter.writeEndElement();
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
    }
}

