/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.ibm.urbancode.zos.generate.artifact.info.ArtifactInfo;
import com.ibm.urbancode.zos.generate.artifact.info.Filters;
import com.ibm.urbancode.zos.generate.artifact.info.LoopType;
import com.ibm.urbancode.zos.generate.artifact.info.utils.PackageManifestDownloader;
import com.ibm.urbancode.zos.xml.utils.common.DeployedVersion;
import com.ibm.urbancode.zos.xml.utils.deploy.PackageManifest;
import com.ibm.urbancode.zos.xml.utils.rollback.RollbackManifest;
import com.urbancode.air.plugin.command.JsonInfoParser;
import com.urbancode.air.plugin.command.MissingInputException;
import com.urbancode.air.plugin.command.MultiGenerateInfoInputs;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang3.StringUtils;

public class MultiGenerateArtifactInfo {
    private final Properties inputProperties;
    private final Properties outputProperties;
    private static final int ERR_CODE = 1;
    private static final String PRESENT_WORKING_DIRECTORY = ".";
    private static final String PACKAGE_MANIFEST_FILE_NAME = "packageManifest.xml";
    private int exitCode = 0;
    private MultiGenerateInfoInputs pluginInputs;

    public MultiGenerateArtifactInfo(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    public int execute() {
        try {
            this.pluginInputs = MultiGenerateInfoInputs.getValidatedInputs(this.inputProperties);
            DeployedVersion deployedVersion = this.pluginInputs.getDeployedVersion();
            if (!deployedVersion.exist()) {
                this.ignoreTargetDatasetIfExist();
                this.ignoreDeployActionIfExist();
            }
            PackageManifest packageManifest = this.getPackageManifest().sort(this.pluginInputs.getOrderBy());
            Optional<RollbackManifest> rollbackManifest = this.getRollbackManifest();
            JsonInfoParser jsonInfoParser = new JsonInfoParser(this.pluginInputs);
            Map<String, Filters> combinedProperties = jsonInfoParser.parse();
            for (Map.Entry<String, Filters> entry : combinedProperties.entrySet()) {
                this.printHeader(entry.getKey());
                ArtifactInfo artifactInfo = rollbackManifest.isPresent() ? ArtifactInfo.generate((Filters)entry.getValue(), (PackageManifest)packageManifest, (RollbackManifest)rollbackManifest.get()) : ArtifactInfo.generate((Filters)entry.getValue(), (PackageManifest)packageManifest);
                String generatedText = StringUtils.chomp(artifactInfo.getText());
                this.printGeneratedTextToConsole(generatedText);
                this.outputProperties.setProperty(entry.getKey(), generatedText);
                String count = Long.toString(artifactInfo.getCount());
                this.outputProperties.setProperty(entry.getKey() + "-count", count);
            }
        }
        catch (MissingInputException | IllegalArgumentException exception) {
            System.out.println(" [Error] " + exception.getMessage());
            this.exitCode = 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.exitCode = 1;
        }
        return this.exitCode;
    }

    private void printHeader(String propertyName) {
        System.out.println();
        System.out.println("************************************************************************************************");
        System.out.println("==> Generating version artifact information for property - " + propertyName);
        System.out.println("************************************************************************************************");
        System.out.println();
    }

    private void ignoreTargetDatasetIfExist() {
        if (!this.pluginInputs.getTargetDatasetJSON().isEmpty()) {
            System.out.println("Warning: Target Dataset Name Filter ignored because version " + this.pluginInputs.getVersionName() + " is not deployed");
            this.pluginInputs.ignoreTargetDatasetJSON();
        }
    }

    private void ignoreDeployActionIfExist() {
        if (!this.pluginInputs.getDeployActionJSON().isEmpty()) {
            System.out.println("Warning: Deployment Action Filter ignored because version " + this.pluginInputs.getVersionName() + " is not deployed");
            this.pluginInputs.ignoreDeployActionJSON();
        }
    }

    private PackageManifest getPackageManifest() throws Exception {
        DeployedVersion deployedVersion = this.pluginInputs.getDeployedVersion();
        if (deployedVersion.exist()) {
            return deployedVersion.getPackageManifest();
        }
        PackageManifestDownloader.download((String)this.pluginInputs.getComponentName(), (String)this.pluginInputs.getVersionName(), (String)this.getVersionWorkingDir());
        return PackageManifest.from((String)this.getManifestFilePath());
    }

    private Optional<RollbackManifest> getRollbackManifest() throws XMLStreamException, IOException {
        if (this.isRollbackManifestOperationsNeeded()) {
            DeployedVersion deployedVersion = this.pluginInputs.getDeployedVersion();
            return Optional.of(deployedVersion.getRollbackManifest());
        }
        return Optional.empty();
    }

    private boolean isRollbackManifestOperationsNeeded() {
        if (!this.pluginInputs.getDeployActionJSON().isEmpty()) {
            return true;
        }
        return this.pluginInputs.getLoopType() == LoopType.DeletedMemberExcludingMissingMembers;
    }

    private void printGeneratedTextToConsole(String generatedText) {
        System.out.println();
        System.out.println("Output text:");
        System.out.println("========================================================================================================================");
        System.out.println(generatedText);
        System.out.println("========================================================================================================================");
    }

    private String getVersionWorkingDir() throws IOException {
        String basePath = new File(PRESENT_WORKING_DIRECTORY).getCanonicalPath();
        return basePath + File.separator + this.pluginInputs.getResourceId() + File.separator + this.pluginInputs.getVersionName();
    }

    private String getManifestFilePath() throws IOException {
        return this.getVersionWorkingDir() + File.separator + PACKAGE_MANIFEST_FILE_NAME;
    }
}

