/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.web.util;

import com.urbancode.commons.util.query.QueryFilter;
import com.urbancode.commons.web.util.DateParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableFilter
extends QueryFilter {
    static Logger log = Logger.getLogger(TableFilter.class);
    public static final String RANGE_HEADER = "Range";
    public static final String ROWS_PER_PAGE_QUERY_PARAM = "rowsPerPage";
    public static final String PAGE_NUMBER_QUERY_PARAM = "pageNumber";
    public static final String ORDER_FIELD_QUERY_PARAM = "orderField";
    public static final String SORT_TYPE_QUERY_PARAM = "sortType";
    public static final String FILTER_FIELDS_QUERY_PARAM = "filterFields";
    public static final String FILTER_VALUE_PREFIX = "filterValue_";
    public static final String FILTER_TYPE_PREFIX = "filterType_";
    public static final String FILTER_CLASS_PREFIX = "filterClass_";
    public static final String FILTER_CLASSNAME_BOOLEAN = "Boolean";
    public static final String FILTER_CLASSNAME_LONG = "Long";
    public static final String FILTER_CLASSNAME_INTEGER = "Integer";
    public static final String FILTER_CLASSNAME_STRING = "String";
    public static final String FILTER_CLASSNAME_UUID = "UUID";
    public static final String FILTER_CLASSNAME_ENUM = "Enum";
    public static final String FILTER_CLASSNAME_DATE = "Date";
    private Map<String, String> filterClasses = new HashMap<String, String>();

    public TableFilter(HttpServletRequest request) {
        this(null, request);
    }

    public TableFilter(UriInfo uriInfo, HttpServletRequest request) {
        List<String> filterFieldNames;
        this.getAndSetSizesFromRequest(request);
        this.setOrderField(this.getQueryParamValue(ORDER_FIELD_QUERY_PARAM, uriInfo, request));
        String sortTypeString = this.getQueryParamValue(SORT_TYPE_QUERY_PARAM, uriInfo, request);
        if (sortTypeString != null && sortTypeString.equals("desc")) {
            this.setDescending(true);
        }
        if ((filterFieldNames = this.getQueryParamValues(FILTER_FIELDS_QUERY_PARAM, uriInfo, request)) != null) {
            for (String fieldName : filterFieldNames) {
                String filterTypeString = this.getQueryParamValue(FILTER_TYPE_PREFIX + fieldName, uriInfo, request);
                List<String> filterFieldValues = this.getQueryParamValues(FILTER_VALUE_PREFIX + fieldName, uriInfo, request);
                ArrayList<Object> values = new ArrayList<Object>();
                for (String value : filterFieldValues) {
                    values.add(value);
                }
                String filterClass = this.getQueryParamValue(FILTER_CLASS_PREFIX + fieldName, uriInfo, request);
                if (filterClass == null) {
                    filterClass = FILTER_CLASSNAME_STRING;
                }
                this.filterClasses.put(fieldName, filterClass);
                QueryFilter.FilterType filterType = QueryFilter.FilterType.fromParamValue(filterTypeString);
                if (values.size() <= 0 && filterType.requiresValue()) continue;
                this.addFilter(fieldName, filterType, values);
            }
        }
    }

    public TableFilter(TableFilter prototype) {
        super(prototype);
        for (QueryFilter.Filter filter : prototype.getFilters()) {
            String fieldName = filter.getFieldName();
            this.filterClasses.put(fieldName, prototype.getFilterClass(fieldName));
        }
    }

    public List<String> getQueryParamValues(String name, UriInfo uriInfo, HttpServletRequest request) {
        List<String> result = new ArrayList<String>();
        if (uriInfo != null) {
            MultivaluedMap queryParamMap = uriInfo.getQueryParameters();
            if (queryParamMap.get((Object)name) != null) {
                result = (List)queryParamMap.get((Object)name);
            }
        } else if (request != null) {
            String[] requestParams = request.getParameterValues(name);
            if (requestParams != null) {
                result = Arrays.asList(requestParams);
            }
        } else {
            throw new NullPointerException("Neither the URI information nor the request was provided when attempting to parse query parameters for table filters.");
        }
        return result;
    }

    public String getQueryParamValue(String queryName, UriInfo uriInfo, HttpServletRequest request) {
        String result;
        if (uriInfo != null) {
            MultivaluedMap queryParamMap = uriInfo.getQueryParameters();
            result = (String)queryParamMap.getFirst((Object)queryName);
        } else if (request != null) {
            result = request.getParameter(queryName);
        } else {
            throw new NullPointerException("Neither the URI information nor the request was provided when attempting to parse query parameters for table filters.");
        }
        return result;
    }

    public List<Object> getConvertedFilterValues(String name) {
        List<Object> rawValues = this.getFilter(name).getValues();
        ArrayList<Object> result = new ArrayList<Object>();
        if (rawValues != null) {
            for (Object rawValue : rawValues) {
                if (rawValue instanceof String) {
                    result.add(this.resolveValue(name, (String)rawValue));
                    continue;
                }
                result.add(rawValue);
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object resolveValue(String fieldName, String value) {
        String filterClass = this.filterClasses.get(fieldName);
        String result = null;
        if (filterClass == null) return value;
        if (FILTER_CLASSNAME_BOOLEAN.equals(filterClass)) {
            return Boolean.valueOf(value);
        }
        if (FILTER_CLASSNAME_LONG.equals(filterClass)) {
            return Long.valueOf(value);
        }
        if (FILTER_CLASSNAME_INTEGER.equals(filterClass)) {
            return Integer.valueOf(value);
        }
        if (FILTER_CLASSNAME_STRING.equals(filterClass)) {
            return value;
        }
        if (FILTER_CLASSNAME_UUID.equals(filterClass)) {
            return UUID.fromString(value);
        }
        if (FILTER_CLASSNAME_ENUM.equals(filterClass)) {
            return this.resolveEnumValue(fieldName, value);
        }
        if (!FILTER_CLASSNAME_DATE.equals(filterClass)) throw new IllegalArgumentException("Unsupported filter classname: " + filterClass);
        DateParser parser = new DateParser();
        return parser.parseDate(value);
    }

    protected Object resolveEnumValue(String fieldName, String value) {
        return value;
    }

    public String getFilterClass(String name) {
        return this.filterClasses.get(name);
    }

    private void getAndSetSizesFromRequest(HttpServletRequest request) {
        String rangeHeader;
        String pageNumberString;
        String rowsPerPageString = request.getParameter(ROWS_PER_PAGE_QUERY_PARAM);
        if (rowsPerPageString != null) {
            this.setRowsPerPage(Integer.valueOf(rowsPerPageString));
        }
        if ((pageNumberString = request.getParameter(PAGE_NUMBER_QUERY_PARAM)) != null) {
            this.setPageNumber(Integer.valueOf(pageNumberString));
        }
        if (rowsPerPageString == null && pageNumberString == null && (rangeHeader = request.getHeader(RANGE_HEADER)) != null && !rangeHeader.isEmpty()) {
            String rangeHeaderValue = rangeHeader.substring(rangeHeader.indexOf("=") + 1);
            String[] rangeParts = rangeHeaderValue.split("-");
            int start = Integer.valueOf(rangeParts[0]);
            int end = start + 9;
            if (rangeParts.length == 2) {
                end = Integer.valueOf(rangeParts[1]);
            }
            this.setRowsPerPage(end - start + 1);
            this.setPageNumber((end + 1) / this.getRowsPerPage());
        }
    }
}

