/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.immutable;

import com.urbancode.commons.util.immutable.IImmutableMap;
import com.urbancode.commons.util.immutable.ISeq;
import com.urbancode.commons.util.immutable.SeqIterator;
import com.urbancode.commons.util.immutable.Util;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

abstract class AImmutableMap<K, V>
implements IImmutableMap<K, V> {
    int _hash = -1;

    protected AImmutableMap() {
    }

    public String toString() {
        Iterator<Map.Entry<K, V>> i = this.entrySet().iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        while (true) {
            Map.Entry<K, V> e = i.next();
            K key = e.getKey();
            V value = e.getValue();
            builder.append((Object)(key == this ? "(this Map)" : key));
            builder.append('=');
            builder.append((Object)(value == this ? "(this Map)" : value));
            if (!i.hasNext()) {
                return builder.append('}').toString();
            }
            builder.append(", ");
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Map)) {
            return false;
        }
        Map m = (Map)obj;
        if (m.size() != this.size() || ((Object)m).hashCode() != this.hashCode()) {
            return false;
        }
        for (Map.Entry<K, V> e : this.entrySet()) {
            boolean found = m.containsKey(e.getKey());
            if (found && Util.equals(e.getValue(), m.get(e.getKey()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this._hash == -1) {
            int hash = 0;
            for (Map.Entry<K, V> e : this.entrySet()) {
                hash += (e.getKey() == null ? 0 : e.getKey().hashCode()) ^ (e.getValue() == null ? 0 : e.getValue().hashCode());
            }
            this._hash = hash;
        }
        return this._hash;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return AImmutableMap.this.iterator();
            }

            @Override
            public int size() {
                return AImmutableMap.this.size();
            }

            @Override
            public int hashCode() {
                return AImmutableMap.this.hashCode();
            }

            @Override
            public boolean contains(Object o) {
                Map.Entry e;
                Map.Entry found;
                return o instanceof Map.Entry && (found = AImmutableMap.this.entryAt((e = (Map.Entry)o).getKey())) != null && Util.equals(found.getValue(), e.getValue());
            }
        };
    }

    @Override
    public abstract V get(Object var1);

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Set<K> keySet() {
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                final Iterator mi = AImmutableMap.this.iterator();
                return new Iterator<K>(){

                    @Override
                    public boolean hasNext() {
                        return mi.hasNext();
                    }

                    @Override
                    public K next() {
                        return ((Map.Entry)mi.next()).getKey();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return AImmutableMap.this.size();
            }

            @Override
            public boolean contains(Object o) {
                return AImmutableMap.this.containsKey(o);
            }
        };
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                final Iterator mi = AImmutableMap.this.iterator();
                return new Iterator<V>(){

                    @Override
                    public boolean hasNext() {
                        return mi.hasNext();
                    }

                    @Override
                    public V next() {
                        return ((Map.Entry)mi.next()).getValue();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return AImmutableMap.this.size();
            }
        };
    }

    Iterator<Map.Entry<K, V>> iterator() {
        return new SeqIterator<Map.Entry<K, V>>(this.seq());
    }

    protected abstract ISeq<Map.Entry<K, V>> seq();

    protected abstract Map.Entry<K, V> entryAt(Object var1);
}

