/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.deploy.common;

import com.ibm.urbancode.zos.deploy.common.ContainerMapperParser;
import com.ibm.urbancode.zos.deploy.common.DataSet;
import com.ibm.urbancode.zos.deploy.common.Member;
import com.ibm.urbancode.zos.deploy.common.PackageManifestParser;
import com.ibm.urbancode.zos.deploy.common.RollbackManifestParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;

public class DeploymentResultHelper {
    private static final String packageManifestFileName = "packageManifest.xml";
    private static final String additionalFolder4BasePath = "deploy";
    private static final String containerMapperFileName = "containerMapper.xml";
    private static final String rollbackManifestFileName = "rollbackManifest.xml";
    private static final String directorycontainername = "directory";

    public static Set<DataSet> getDeployedDataSets(String deployBasePath, String componentName, String versionName) throws IOException, XMLStreamException {
        System.out.println("This method is deprecated.");
        return DeploymentResultHelper.getDeployedDataSets(deployBasePath, null, componentName, versionName);
    }

    public static Set<DataSet> getDeployedDataSets(String deployBasePath, String resourceId, String componentName, String versionName) throws IOException, XMLStreamException {
        Set<DataSet> deployedDatasets = null;
        InputStream packageManifestInputStream = null;
        Map<String, String> rulerMapper = null;
        try {
            packageManifestInputStream = new FileInputStream(DeploymentResultHelper.getDeployMetaFilePath(deployBasePath, resourceId, componentName, versionName, packageManifestFileName, true));
            deployedDatasets = PackageManifestParser.parseDeployedDatasets(packageManifestInputStream);
            rulerMapper = DeploymentResultHelper.getDeployContainerMapper(deployBasePath, resourceId, componentName, versionName);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        finally {
            if (null != packageManifestInputStream) {
                packageManifestInputStream.close();
            }
        }
        for (DataSet currentDeployedDataSet : deployedDatasets) {
            if (directorycontainername.equals(currentDeployedDataSet.getType())) continue;
            String currentTargetDsName = rulerMapper.get(currentDeployedDataSet.getName());
            currentDeployedDataSet.setName(currentTargetDsName);
            if (currentDeployedDataSet.getMembers() == null) continue;
            for (Member member : currentDeployedDataSet.getMembers()) {
                member.setDataSetName(currentTargetDsName);
            }
        }
        return deployedDatasets;
    }

    public static HashMap<String, HashMap<String, Set<String>>> getRollbackStructure(String deployBasePath, String resourceId, String componentName, String versionName) throws IOException, XMLStreamException {
        HashMap<String, HashMap<String, Set<String>>> rollbackHashMap = new HashMap();
        InputStream rollbackInputStream = null;
        try {
            rollbackInputStream = new FileInputStream(DeploymentResultHelper.getDeployMetaFilePath(deployBasePath, resourceId, componentName, versionName, rollbackManifestFileName, true));
            rollbackHashMap = RollbackManifestParser.parseDataFromRollbackXml(rollbackInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        finally {
            if (null != rollbackInputStream) {
                rollbackInputStream.close();
            }
        }
        return rollbackHashMap;
    }

    public static Set<DataSet> getNotDeployedDataSets(String manifestFilePath) throws IOException, XMLStreamException {
        Set<DataSet> notDeployedDatasets = null;
        FileInputStream packageManifestInputStream = null;
        try {
            packageManifestInputStream = new FileInputStream(manifestFilePath);
            notDeployedDatasets = PackageManifestParser.parseDeployedDatasets(packageManifestInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        finally {
            if (null != packageManifestInputStream) {
                ((InputStream)packageManifestInputStream).close();
            }
        }
        return notDeployedDatasets;
    }

    public static boolean checkVersionDeployed(String deployBasePath, String componentName, String versionName) throws IOException, XMLStreamException {
        System.out.println("This method is deprecated.");
        return DeploymentResultHelper.checkVersionDeployed(deployBasePath, null, componentName, versionName);
    }

    public static boolean checkVersionDeployed(String deployBasePath, String resourceId, String componentName, String versionName) throws IOException, XMLStreamException {
        String packageManifestFilePath = DeploymentResultHelper.getDeployMetaFilePath(deployBasePath, resourceId, componentName, versionName, packageManifestFileName, false);
        File packageManifestFile = new File(packageManifestFilePath);
        return packageManifestFile.exists();
    }

    private static Map<String, String> getDeployContainerMapper(String deployBasePath, String resourceId, String componentName, String versionName) throws IOException, XMLStreamException {
        FileInputStream containerMapperInputStream = null;
        String containerMapperFilePath = DeploymentResultHelper.getDeployMetaFilePath(deployBasePath, resourceId, componentName, versionName, containerMapperFileName, false);
        File file = new File(containerMapperFilePath);
        if (!file.exists() || !file.isFile()) {
            return new HashMap<String, String>();
        }
        containerMapperInputStream = new FileInputStream(DeploymentResultHelper.getDeployMetaFilePath(deployBasePath, resourceId, componentName, versionName, containerMapperFileName, false));
        return ContainerMapperParser.parseDeployRulerMapper(containerMapperInputStream);
    }

    private static String getDeployMetaFilePath(String deployBasePath, String resourceId, String componentName, String versionName, String fileName, boolean checkExist) {
        File file;
        String metaFilePath = DeploymentResultHelper.getVersionBasePath(deployBasePath, resourceId, componentName, versionName) + File.separator + fileName;
        if (!(!checkExist || (file = new File(metaFilePath)).exists() && file.isFile())) {
            throw new IllegalArgumentException(metaFilePath + " not found, please make sure the version has been successfully deployed");
        }
        return metaFilePath;
    }

    private static String getVersionBasePath(String deployBasePath, String resourceId, String componentName, String versionName) {
        File file;
        String versionBasePath;
        String oldVersionBasePath = versionBasePath = deployBasePath + File.separator + additionalFolder4BasePath + File.separator + componentName + File.separator + versionName;
        if (!(null == resourceId || (file = new File(versionBasePath = deployBasePath + File.separator + additionalFolder4BasePath + File.separator + resourceId + File.separator + componentName + File.separator + versionName)).exists() && file.isDirectory())) {
            versionBasePath = oldVersionBasePath;
        }
        return versionBasePath;
    }
}

