/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.commons.fileutils.DirectoryFileFilter;
import com.urbancode.commons.fileutils.FileUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class ReplaceTokensUSS {
    private Properties inputProperties;
    private Properties outputProperties;

    public ReplaceTokensUSS(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() throws IOException, Exception {
        try {
            String workDir = new File(".").getCanonicalPath();
            String propFileName = this.inputProperties.getProperty("propFile");
            String dirOffset = ReplaceTokensUSS.isNullOrEmpty(this.inputProperties.getProperty("dir")) ? "." : this.inputProperties.getProperty("dir").trim();
            File offsetFolder = new File(workDir, dirOffset);
            if (!offsetFolder.isDirectory()) {
                System.out.println("[Ok] Creating temporary offset directory...");
                offsetFolder.mkdir();
                offsetFolder.deleteOnExit();
            }
            workDir = offsetFolder.getCanonicalPath();
            String includes = this.inputProperties.getProperty("includes").replaceAll("\r\n|\n|\n\r|\r", ",");
            String excludes = this.inputProperties.getProperty("excludes").replaceAll("\r\n|\n|\n\r|\r", ",");
            String startDelimiter = ReplaceTokensUSS.isNullOrEmpty(this.inputProperties.getProperty("startDelimiter")) ? "" : this.inputProperties.getProperty("startDelimiter");
            String endDelimiter = ReplaceTokensUSS.isNullOrEmpty(this.inputProperties.getProperty("endDelimiter")) ? "" : this.inputProperties.getProperty("endDelimiter");
            String propertyPrefix = this.inputProperties.getProperty("propertyPrefix");
            String envPropValues = this.inputProperties.getProperty("envPropValues");
            String explicitTokens = this.inputProperties.getProperty("explicitTokens");
            String customEncoding = this.inputProperties.getProperty("customEncoding");
            File propFile = new File(workDir, propFileName);
            boolean propFileExists = false;
            String encoding = null;
            boolean encodingSupported = false;
            if (!ReplaceTokensUSS.isNullOrEmpty(customEncoding)) {
                try {
                    encodingSupported = Charset.isSupported(customEncoding);
                }
                catch (IllegalArgumentException iae) {
                    System.out.println("[error]  Encoding type " + customEncoding + " not valid.");
                    System.out.println("[possible solution]  Please update the step configuration with a valid encoding type.");
                    System.exit(1);
                }
                if (!encodingSupported) {
                    System.out.println("[error]  Encoding type " + customEncoding + " not supported.");
                    System.out.println("[possible solution]  Please update the step configuration with a supported encoding type.");
                    System.exit(1);
                } else {
                    encoding = customEncoding;
                }
            } else {
                File AGENT_HOME = null;
                if (!ReplaceTokensUSS.isNullOrEmpty(System.getenv().get("AGENT_HOME"))) {
                    AGENT_HOME = new File(System.getenv().get("AGENT_HOME"));
                }
                if (AGENT_HOME.isDirectory()) {
                    File agentInstalledProps = new File(AGENT_HOME, "conf/agent/installed.properties");
                    Properties agentProps = new Properties();
                    FileInputStream agentInputStream = null;
                    try {
                        agentInputStream = new FileInputStream(agentInstalledProps);
                        agentProps.load(agentInputStream);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    encoding = agentProps.getProperty("system.default.encoding");
                } else {
                    encoding = Charset.defaultCharset().name();
                }
            }
            try {
                Properties properties = new Properties();
                if (propFile.exists() && propFile.isFile()) {
                    propFileExists = true;
                    System.out.println("Found existing input property file: " + propFile.getCanonicalPath());
                    Properties tempProps = new Properties();
                    FileInputStream in = new FileInputStream(propFile);
                    tempProps.load(in);
                    Set<String> keys = tempProps.stringPropertyNames();
                    for (String key : keys) {
                        properties.setProperty(startDelimiter + key + endDelimiter, tempProps.getProperty(key));
                    }
                }
                if (!ReplaceTokensUSS.isNullOrEmpty(envPropValues)) {
                    if (!ReplaceTokensUSS.isNullOrEmpty(propertyPrefix)) {
                        System.out.println("Looking for properties starting with " + propertyPrefix);
                    }
                    String[] prop = envPropValues.split("(?<=(^|[^\\\\])(\\\\{2}){0,8}),");
                    for (int i = 0; i < prop.length; ++i) {
                        String propValue;
                        String[] parts = prop[i].split("(?<=(^|[^\\\\])(\\\\{2}){0,8})=", 2);
                        String propName = parts[0];
                        String string = propValue = parts.length == 2 ? parts[1] : "";
                        if (ReplaceTokensUSS.isNullOrEmpty(propName)) continue;
                        propName = propName.replace("\\=", "=").replace("\\,", ",").replace("\\\\", "\\");
                        propValue = propValue.replace("\\=", "=").replace("\\,", ",").replace("\\\\", "\\");
                        if (!ReplaceTokensUSS.isNullOrEmpty(propertyPrefix) && !propName.startsWith(propertyPrefix) || ReplaceTokensUSS.isNullOrEmpty(propName)) continue;
                        properties.setProperty(startDelimiter + propName + endDelimiter, propValue);
                    }
                }
                if (!ReplaceTokensUSS.isNullOrEmpty(explicitTokens)) {
                    BufferedReader reader = new BufferedReader(new StringReader(explicitTokens));
                    String line = reader.readLine();
                    boolean noOfOccurences = false;
                    while (line != null) {
                        if (line.indexOf("->") > 0) {
                            int index = line.indexOf("->");
                            String propName = line.substring(0, index).trim();
                            String propValue = index < line.length() - 2 ? line.substring(index + 2) : "";
                            properties.setProperty(propName, propValue);
                        } else {
                            System.out.println("Found invalid explicit token " + line + " - missing -> separator");
                            System.exit(1);
                        }
                        line = reader.readLine();
                    }
                }
                if (ReplaceTokensUSS.isNullOrEmpty(propFileName)) {
                    System.out.println("Creating temporary property file. Results will display one additional replacement per token due to this file.");
                    propFile = File.createTempFile("tmp", ".properties", new File(workDir));
                    propFileName = propFile.getName();
                }
                FileOutputStream fileOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(propFile);
                    properties.store(fileOutputStream, "Auto generated property file");
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
                finally {
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                    }
                    catch (IOException ioe) {
                        System.out.println("Error in closing the properties file");
                        System.exit(1);
                    }
                }
                Set<String> propKeys = properties.stringPropertyNames();
                for (String key : propKeys) {
                    System.out.println("added: " + key + ":" + properties.getProperty(key));
                }
                if (properties.size() > 0) {
                    int i;
                    System.out.println("Replacing tokens in files located in " + workDir);
                    String[] includePatternArray = includes.split("\\s|,");
                    String[] excludePatternArray = excludes.split("\\s|,");
                    File baseDir = new File(workDir);
                    DirectoryFileFilter fileFilter = DirectoryFileFilter.getFilter(baseDir);
                    if (includePatternArray != null) {
                        for (i = 0; i < includePatternArray.length; ++i) {
                            if (includePatternArray[i].endsWith("/")) {
                                includePatternArray[i] = includePatternArray[i] + "**/*";
                            }
                            fileFilter.addInclude(includePatternArray[i]);
                        }
                    }
                    if (excludePatternArray != null) {
                        for (i = 0; i < excludePatternArray.length; ++i) {
                            if (excludePatternArray[i].endsWith("/")) {
                                excludePatternArray[i] = excludePatternArray[i] + "**/*";
                            }
                            fileFilter.addExclude(excludePatternArray[i]);
                        }
                    }
                    Iterator fileIterator = FileUtils.getDirectoryFiles(baseDir, fileFilter);
                    LinkedHashSet<String> includedFiles = new LinkedHashSet<String>();
                    while (fileIterator.hasNext()) {
                        File file = (File)fileIterator.next();
                        String path = file.getAbsolutePath();
                        includedFiles.add(path);
                    }
                    Iterator it = includedFiles.iterator();
                    int replaceCounts = 0;
                    int modifiedFiles = 0;
                    String filePathStr = "";
                    while (it.hasNext()) {
                        filePathStr = it.next().toString();
                        int modifiedCounts = ReplaceTokensUSS.modifyFileWithReplaceProperties(filePathStr, properties, encoding);
                        if (modifiedCounts > 0) {
                            ++modifiedFiles;
                        }
                        replaceCounts += modifiedCounts;
                    }
                    System.out.println("  [replace] Replaced " + replaceCounts + " occurrences in " + modifiedFiles + " files.");
                } else {
                    System.out.println("Did not find any properties or explicit tokens for replacement.");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Error replacing tokens!");
                if (propFile != null && !propFileExists) {
                    propFile.delete();
                }
                System.exit(1);
            }
            finally {
                if (propFile != null && !propFileExists) {
                    propFile.delete();
                }
            }
            if (!propFileExists) {
                System.out.println("Temporary property file deleted.");
            }
        }
        catch (Exception e) {
            System.out.println("Error while executing program ");
            e.printStackTrace();
            System.exit(1);
        }
        return 0;
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }

    public static String convertStringToRequiredEncoding(String instr, String inEncoding) throws UnsupportedEncodingException {
        byte[] chBytes = instr.getBytes(inEncoding);
        String encStr = new String(chBytes);
        return encStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int modifyFileWithReplaceProperties(String filePath, Properties replaceProperties, String reqEncoding) {
        File fileToBeModified = new File(filePath);
        String fileData = "";
        int fileOccurences = 0;
        BufferedWriter writer = null;
        try {
            FileInputStream fisTargetFile = new FileInputStream(fileToBeModified);
            fileData = IOUtils.toString((InputStream)fisTargetFile, (String)reqEncoding);
            Enumeration<?> enums = replaceProperties.propertyNames();
            while (enums.hasMoreElements()) {
                String rKey = (String)enums.nextElement();
                String rValue = replaceProperties.getProperty(rKey);
                fileOccurences += StringUtils.countMatches((CharSequence)fileData, (CharSequence)rKey);
                fileData = StringUtils.replace((String)fileData, (String)rKey, (String)rValue);
            }
            if (fileOccurences > 0) {
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), reqEncoding));
                writer.write(fileData);
                System.out.println(" Changed => " + filePath);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        return fileOccurences;
    }
}

