/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.deploy.common;

import com.ibm.urbancode.zos.deploy.common.DataSet;
import com.ibm.urbancode.zos.deploy.common.Member;
import com.ibm.urbancode.zos.deploy.common.XmlHelper;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class PackageManifestParser {
    private static final String DELETED_TAG = "deleted";
    private static final String CONTAINER_TAG = "container";
    private static final String RESOURCE_TAG = "resource";
    private static final String PROPERTY_TAG = "property";
    private static final String INPUTS_TAG = "inputs";
    private static final String INPUT_TAG = "input";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String DEPLOY_TYPE_ATTRIBUTE = "deployType";
    private static final String PROPERTY_TAG_NAME_ATTRIBUTE = "name";
    private static final String PROPERTY_TAG_VALUE_ATTRIBUTE = "value";
    private static final String INPUT_TAG_URL_ATTRIBUTE = "url";
    private static final String INPUT_TAG_NAME_ATTRIBUTE = "name";
    private static final String INPUT_TAG_VERSION_ATTRIBUTE = "version";
    private static final String INPUT_TAG_COMPILE_TYPE_ATTRIBUTE = "compileType";

    public static Set<DataSet> parseDeployedDatasets(InputStream packageManifestInputStream) throws XMLStreamException {
        LinkedHashMap<String, DataSet> deployedDatasetMap = new LinkedHashMap<String, DataSet>();
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        XMLEventReader eventReader4Dataset = inputFactory.createXMLEventReader(packageManifestInputStream, "CP037");
        DataSet currentDataset = null;
        String currentDataSetName = null;
        String currentDataSetDeployType = null;
        Member currentMember = null;
        boolean deleted = false;
        while (eventReader4Dataset.hasNext()) {
            String tagName;
            XMLEvent event = eventReader4Dataset.nextEvent();
            if (event.isStartElement()) {
                String propertyName;
                StartElement startElement = event.asStartElement();
                tagName = startElement.getName().getLocalPart().trim();
                if (tagName.equalsIgnoreCase(DELETED_TAG)) {
                    deleted = true;
                    continue;
                }
                if (tagName.equalsIgnoreCase(CONTAINER_TAG)) {
                    currentDataSetName = XmlHelper.getAttributeValue(startElement, "name");
                    String currentDataSetNameKey = deleted ? currentDataSetName + "_DELETE" : currentDataSetName;
                    currentDataSetDeployType = XmlHelper.getAttributeValue(startElement, DEPLOY_TYPE_ATTRIBUTE);
                    String currentDataSetType = XmlHelper.getAttributeValue(startElement, TYPE_ATTRIBUTE);
                    if (deployedDatasetMap.containsKey(currentDataSetNameKey)) {
                        currentDataset = (DataSet)deployedDatasetMap.get(currentDataSetNameKey);
                        continue;
                    }
                    currentDataset = new DataSet();
                    currentDataset.setType(currentDataSetType);
                    currentDataset.setDeployType(currentDataSetDeployType);
                    currentDataset.setName(currentDataSetName);
                    currentDataset.setSrcDataSetName(currentDataSetName);
                    currentDataset.setDelete(deleted);
                    deployedDatasetMap.put(currentDataSetNameKey, currentDataset);
                    continue;
                }
                if (tagName.equalsIgnoreCase(RESOURCE_TAG)) {
                    if (null == currentDataset || null == currentDataSetName) continue;
                    String memberName = XmlHelper.getAttributeValue(startElement, "name");
                    String memberType = XmlHelper.getAttributeValue(startElement, TYPE_ATTRIBUTE);
                    String memberDeployType = XmlHelper.getAttributeValue(startElement, DEPLOY_TYPE_ATTRIBUTE);
                    if (null == memberDeployType || memberDeployType.length() == 0) {
                        memberDeployType = currentDataSetDeployType;
                    }
                    Member dsMember = new Member(memberName);
                    dsMember.setType(memberType);
                    dsMember.setDataSetName(currentDataSetName);
                    dsMember.setSrcDataSetName(currentDataSetName);
                    dsMember.setDeployType(memberDeployType);
                    currentMember = dsMember;
                    currentDataset.addMember(dsMember);
                    continue;
                }
                if (tagName.equalsIgnoreCase(PROPERTY_TAG)) {
                    propertyName = XmlHelper.getAttributeValue(startElement, "name");
                    String propertyValue = XmlHelper.getAttributeValue(startElement, PROPERTY_TAG_VALUE_ATTRIBUTE);
                    if (null == propertyName || propertyName.length() <= 0) continue;
                    if (null == propertyValue) {
                        propertyValue = "";
                    }
                    if (null != currentMember) {
                        currentMember.addCustomerProperty(propertyName, propertyValue);
                        continue;
                    }
                    if (null == currentDataset) continue;
                    currentDataset.addCustomerProperty(propertyName, propertyValue);
                    continue;
                }
                if (tagName.equalsIgnoreCase(INPUTS_TAG)) {
                    String propertyUrl = XmlHelper.getAttributeValue(startElement, INPUT_TAG_URL_ATTRIBUTE);
                    if (null == currentMember) continue;
                    currentMember.getInputs().setUrl(propertyUrl);
                    continue;
                }
                if (!tagName.equalsIgnoreCase(INPUT_TAG)) continue;
                propertyName = XmlHelper.getAttributeValue(startElement, "name");
                String propertyVersion = XmlHelper.getAttributeValue(startElement, INPUT_TAG_VERSION_ATTRIBUTE);
                String propertyUrl = XmlHelper.getAttributeValue(startElement, INPUT_TAG_URL_ATTRIBUTE);
                String propertyCompileType = XmlHelper.getAttributeValue(startElement, INPUT_TAG_COMPILE_TYPE_ATTRIBUTE);
                if (null == currentMember) continue;
                currentMember.getInputs().addInput(propertyName, propertyVersion, propertyUrl, propertyCompileType);
                continue;
            }
            if (!event.isEndElement()) continue;
            EndElement endElement = event.asEndElement();
            tagName = endElement.getName().getLocalPart().trim();
            if (tagName.equalsIgnoreCase(DELETED_TAG)) {
                deleted = false;
                continue;
            }
            if (tagName.equalsIgnoreCase(CONTAINER_TAG)) {
                currentDataset = null;
                currentDataSetName = null;
                currentDataSetDeployType = null;
                continue;
            }
            if (!tagName.equalsIgnoreCase(RESOURCE_TAG)) continue;
            currentMember = null;
        }
        return new LinkedHashSet<DataSet>(deployedDatasetMap.values());
    }
}

