/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZFileException;
import com.ibm.urbancode.zos.packaging.common.InsufficientFilePermissionsException;
import com.urbancode.air.plugin.command.utils.DatasetException;
import com.urbancode.air.plugin.command.utils.MissingInputException;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Properties;

public class PluginInputs {
    public static final String SOURCE_TYPE = "sourceType";
    public static final String SOURCE_VALUE = "sourceValue";
    public static final String SYSPROC_DATASETS = "sysprocDatasets";
    public static final String ARGUMENTS = "rexxArguments";
    public static final String TEMP_DSN_PREFIX = "tempDsnPrefix";
    public static final String ISPF_GATEWAY_PATH = "ispfGatewayPath";
    private static final String DATASET = "DATASET";
    private final String sourceType;
    private final String sourceValue;
    private final String sysprocDatasets;
    private final String rexxArguments;
    private final String dsnPrefix;
    private final String ispfGatewayPath;

    public PluginInputs(Properties inputProperties) {
        this.sourceType = inputProperties.getProperty(SOURCE_TYPE);
        String string = this.sourceValue = this.isSourceTypeDataset() ? this.getFullyQualifiedSourceDataset(inputProperties.getProperty(SOURCE_VALUE).trim().toUpperCase()) : inputProperties.getProperty(SOURCE_VALUE);
        if (this.sourceValue.isEmpty()) {
            throw new MissingInputException(" [Error] Source value is mandatory.");
        }
        this.sysprocDatasets = inputProperties.getProperty(SYSPROC_DATASETS).trim().toUpperCase();
        this.rexxArguments = this.encloseArgumentsInSingleQuotes(inputProperties.getProperty(ARGUMENTS).trim());
        String inputDsnPrefix = inputProperties.getProperty(TEMP_DSN_PREFIX).trim();
        this.dsnPrefix = inputDsnPrefix.isEmpty() ? ZFile.getDefaultHLQ() : inputDsnPrefix.toUpperCase();
        this.ispfGatewayPath = inputProperties.getProperty(ISPF_GATEWAY_PATH).trim();
        if (this.ispfGatewayPath.isEmpty()) {
            throw new MissingInputException(" [Error] ISPF Gateway path is mandatory.");
        }
    }

    private String getFullyQualifiedSourceDataset(String sourceValue) {
        return sourceValue.startsWith("'") ? sourceValue : "'" + ZFile.getFullyQualifiedDSN(sourceValue, false) + "'";
    }

    public void validateInputs() throws ZFileException, FileNotFoundException {
        if (this.isSourceTypeDataset()) {
            this.checkIfDatasetExist();
        }
        this.checkIfIspfFileExists();
    }

    private void checkIfIspfFileExists() throws FileNotFoundException {
        String ISPZXML = this.ispfGatewayPath + File.separator + "ISPZXML";
        File ispfzxmlFile = new File(ISPZXML);
        if (!ispfzxmlFile.exists()) {
            throw new FileNotFoundException(" [Error] " + ISPZXML + " doesn't exists. Ensure the ispf gateway value in the plugin step exists in filesystem");
        }
        if (!ispfzxmlFile.canExecute() || !ispfzxmlFile.canRead()) {
            throw new InsufficientFilePermissionsException(" [ERROR] ISPZXML file does not have Execute and Read permission in ISPF gateway path " + this.ispfGatewayPath);
        }
    }

    private void checkIfDatasetExist() throws ZFileException {
        if (!ZFile.dsExists(this.sourceValue)) {
            throw new DatasetException(" [Error] " + this.sourceValue + " doesn't exists.");
        }
    }

    private String encloseArgumentsInSingleQuotes(String arguments) {
        String enclosedArguments = "";
        if (!this.isNullOrEmpty(arguments)) {
            enclosedArguments = arguments.startsWith("'") ? arguments : "'" + arguments + "'";
        }
        return enclosedArguments;
    }

    private boolean isNullOrEmpty(String arguments) {
        return arguments == null || arguments.trim().isEmpty();
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public String getSourceValue() {
        return this.sourceValue;
    }

    public String getSysprocDatasets() {
        return this.sysprocDatasets;
    }

    public String getRexxArguments() {
        return this.rexxArguments;
    }

    public String getDsnPrefix() {
        return this.dsnPrefix;
    }

    public String getIspfGatewayPath() {
        return this.ispfGatewayPath;
    }

    private boolean isSourceTypeDataset() {
        return this.sourceType.equals(DATASET);
    }
}

