/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.air.plugin.command.RexxCodeSnippets;
import com.urbancode.air.plugin.command.utils.FileException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public class TempIspfFileHelper {
    private static final String SYSPROC = "sysproc";
    private final String tempDataset;
    private final String userSysprocDatasets;
    private File tempDirectoryForStoringGatewayFiles;
    private final String dsnPrefix;
    private static final String AGENT_ISPF_CONF_FILE = System.getenv("AGENT_HOME") + "/conf/toolkit/ISPF.conf";
    private static final String ISPF_CONF_FILE = "/ISPF.conf";
    private static final String ISPZXENV = "/ISPZXENV";
    private static final String AGENT_HOME_ISPF_LOG_PATH = System.getenv("AGENT_HOME") + "/var/work/";

    public TempIspfFileHelper(String tempDataset, String userSysprocDatasets, String dsnPrefix) {
        this.tempDataset = tempDataset;
        this.userSysprocDatasets = userSysprocDatasets;
        this.dsnPrefix = dsnPrefix;
    }

    protected void setUpIspf() throws IOException {
        this.createDirectoryToStoreIspfFiles();
        File ispzxenvFile = this.createFile(ISPZXENV);
        File ispfConfFile = this.createFile(ISPF_CONF_FILE);
        this.setExecutableOnIspzxenvFile(ispzxenvFile);
        this.populateIspfConfFile(ispfConfFile);
        this.populateIspzxenvFile(ispzxenvFile);
    }

    private void setExecutableOnIspzxenvFile(File ispzxenvFile) {
        if (!ispzxenvFile.setExecutable(true, false)) {
            throw new FileException("Unable to set executable permissions for ISPZXENV file.");
        }
    }

    private void createDirectoryToStoreIspfFiles() {
        SimpleDateFormat sdfDate = new SimpleDateFormat("HHmmss.SSS");
        String strDate = sdfDate.format(new Date());
        this.tempDirectoryForStoringGatewayFiles = new File(AGENT_HOME_ISPF_LOG_PATH + strDate.substring(0, 6) + "-" + strDate.substring(7, 10) + "-REXX-PLUGIN");
        if (!this.tempDirectoryForStoringGatewayFiles.mkdir()) {
            throw new FileException("Unable to create directory at " + this.tempDirectoryForStoringGatewayFiles);
        }
        this.tempDirectoryForStoringGatewayFiles.deleteOnExit();
    }

    private File createFile(String fileName) throws IOException {
        File file = new File(this.tempDirectoryForStoringGatewayFiles.getPath() + fileName);
        if (!file.createNewFile()) {
            throw new FileException("Unable to create " + file.getPath() + " file");
        }
        file.deleteOnExit();
        return file;
    }

    private void populateIspzxenvFile(File ispzxenvFile) throws IOException {
        String ISPZXENV_str = RexxCodeSnippets.getCustomIspzxenvRexx(this.tempDirectoryForStoringGatewayFiles.getPath(), this.dsnPrefix);
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(ispzxenvFile));){
            bw.write(ISPZXENV_str);
            bw.flush();
        }
    }

    private void populateIspfConfFile(File ispfConfFile) throws IOException {
        Properties ispfConfProperties = TempIspfFileHelper.getPropertiesFromAgentIspfConfFile();
        String updatedSysproc = this.getUpdatedSysproc(ispfConfProperties.getProperty(SYSPROC));
        ispfConfProperties.put(SYSPROC, updatedSysproc);
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(ispfConfFile));){
            ispfConfProperties.store(bw, "dynamic ISPF file for this plugin execution");
            bw.flush();
        }
    }

    private String getUpdatedSysproc(String agentIspfConfSysproc) {
        String updatedSysproc = agentIspfConfSysproc.isEmpty() ? this.tempDataset : this.tempDataset + "," + agentIspfConfSysproc;
        if (!this.userSysprocDatasets.isEmpty()) {
            updatedSysproc = updatedSysproc + "," + this.userSysprocDatasets;
        }
        return updatedSysproc;
    }

    private static Properties getPropertiesFromAgentIspfConfFile() throws IOException {
        File agentIspfConfFile = new File(AGENT_ISPF_CONF_FILE);
        Properties ispfConfProperties = new Properties();
        try (BufferedReader br = new BufferedReader(new FileReader(agentIspfConfFile));){
            ispfConfProperties.load(br);
        }
        return ispfConfProperties;
    }

    public String getTemporaryIspfDirectory() throws IOException {
        return this.tempDirectoryForStoringGatewayFiles.getCanonicalPath();
    }
}

