/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.ibm.jzos.RecordWriter;
import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZFileException;
import com.ibm.jzos.ZUtil;
import com.urbancode.air.plugin.command.RexxCodeSnippets;
import com.urbancode.air.plugin.command.utils.DatasetException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TempDatasetHelper {
    public static final int LRECL = 144;
    public static final String SETPROP = "SETPROP";
    public static final String GETDLMTR = "GETDLMTR";
    public static final String DRIVER = "BUZDRVR";
    public static final String INPUT = "INPUT";
    private static final String SOURCE_TYPE_INLINE = "INLINE";
    private static final int BLK_SIZE = 27792;
    public static final String TIMESTAMP_FORMAT = "HHmmss.SSS";
    public static final String MID_QUALIFIER = ".BUZREXX.R";
    private final String inputDsnPrefix;
    private final String inputSourceType;
    private final String inputSourceValue;
    private final String inputArguments;
    private String tempDataset;
    private String rexxOutputPropertiesDataset;
    private final String userProgram;

    public TempDatasetHelper(String inputDsnPrefix, String inputSourceType, String inputSourceValue, String inputArguments) throws NoSuchAlgorithmException {
        this.inputDsnPrefix = inputDsnPrefix;
        this.inputSourceType = inputSourceType;
        this.inputSourceValue = inputSourceValue;
        this.inputArguments = inputArguments;
        this.generateUniqueDatasetName();
        this.userProgram = this.getUserProgram(inputSourceType, inputSourceValue);
    }

    private String getUserProgram(String sourceType, String sourceValue) {
        if (sourceType.equals(SOURCE_TYPE_INLINE)) {
            return "'" + this.tempDataset + "(" + INPUT + ")'";
        }
        return sourceValue;
    }

    public void createTemporaryDatasets() throws ZFileException {
        this.createEmptyPDSForHelperPrograms();
        this.createDatasetToStoreOutputProperties();
    }

    private void createEmptyPDSForHelperPrograms() throws ZFileException {
        String ddName = ZFile.allocDummyDDName();
        String createDatasetCmd = "alloc fi(" + ddName + ") da(" + this.tempDataset + ") reuse new catalog msg(wtp) recfm(f,b) space(5,5) cyl dir(1) lrecl(" + 144 + ") blksize(" + 27792 + ")";
        this.createDatasetWithGivenDDStatement(createDatasetCmd, ddName);
    }

    private void createDatasetToStoreOutputProperties() throws ZFileException {
        this.rexxOutputPropertiesDataset = this.tempDataset + ".PROP";
        String ddName = ZFile.allocDummyDDName();
        String createDatasetCmd = "alloc fi(" + ddName + ") da(" + this.rexxOutputPropertiesDataset + ") reuse new catalog msg(wtp) recfm(f,b) space(5,5) cyl lrecl(" + 1000 + ") blksize(" + 27000 + ")";
        this.createDatasetWithGivenDDStatement(createDatasetCmd, ddName);
    }

    private void generateUniqueDatasetName() throws NoSuchAlgorithmException {
        SecureRandom rand = SecureRandom.getInstanceStrong();
        String randomizedDsnPrefix = this.inputDsnPrefix + MID_QUALIFIER + rand.nextInt(1000000);
        SimpleDateFormat sdfDate = new SimpleDateFormat(TIMESTAMP_FORMAT);
        String strDate = sdfDate.format(new Date());
        this.tempDataset = randomizedDsnPrefix + ".T" + strDate.substring(0, 6) + ".M" + strDate.substring(7, 10);
    }

    private void createDatasetWithGivenDDStatement(String createDatasetCmd, String ddName) throws ZFileException {
        ZFile.bpxwdyn(createDatasetCmd);
        ZFile.bpxwdyn("free fi(" + ddName + ") msg(wtp)");
        if (!ZFile.dsExists(ZFile.getSlashSlashQuotedDSN(this.tempDataset, true))) {
            throw new DatasetException("Temporary dataset " + this.tempDataset + " couldn't be created.");
        }
    }

    private void copyCodeToPDSMember(String memberName, String rexxStatements) throws IOException {
        RecordWriter writer = RecordWriter.newWriter(ZFile.getSlashSlashQuotedDSN(this.tempDataset + "(" + memberName + ")", true), 4);
        try (BufferedReader br = new BufferedReader(new StringReader(rexxStatements));){
            String line;
            while ((line = br.readLine()) != null) {
                String formattedLine = String.format("%-144s", line.replaceAll("\\s+$", ""));
                byte[] buff = formattedLine.getBytes(ZUtil.getDefaultPlatformEncoding());
                writer.write(buff, 0, buff.length);
            }
        }
        writer.close();
        writer.flush();
    }

    public void populateRexxCodeSnippets() throws IOException {
        this.copyCodeToPDSMember(SETPROP, RexxCodeSnippets.getSetPropertyProgram(this.rexxOutputPropertiesDataset));
        this.copyCodeToPDSMember(GETDLMTR, RexxCodeSnippets.getDelimiterProgram());
        if (this.inputSourceType.equals(SOURCE_TYPE_INLINE)) {
            this.copyCodeToPDSMember(INPUT, this.inputSourceValue);
        }
        String userRexxCommandWithArguments = this.inputArguments.isEmpty() ? this.userProgram : this.userProgram + " " + this.inputArguments;
        this.copyCodeToPDSMember(DRIVER, RexxCodeSnippets.getDriverRexxProgramWithInputRexx(userRexxCommandWithArguments));
    }

    public String getRexxOutputPropertiesDataset() {
        return this.rexxOutputPropertiesDataset;
    }

    public String getDriverProgramDataset() {
        return this.getTempDataset() + "(" + DRIVER + ")";
    }

    public String getTempDataset() {
        return this.tempDataset;
    }
}

