/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.jes;

import com.ibm.urbancode.zos.jes.JESJobDataset;
import com.ibm.urbancode.zos.jes.JMConnection;
import com.ibm.urbancode.zos.jes.Logger;
import com.ibm.urbancode.zos.jes.utils.IJESMinerConstants;
import com.ibm.urbancode.zos.jes.utils.JmonProtocol;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class JESJob {
    public static final String copyright = "";
    private String jobName;
    private String jobID;
    private String jobClass;
    private String sysoutClass;
    private String outputNode;
    private String execNode;
    private String jobOwner;
    private String systemName;
    private String memberName;
    private String deviceName;
    private String jobPhase;
    private String holdStatus;
    private String jobType;
    private String priority;
    private String returnCode;
    private String systemReturnCode;
    private String userReturnCode;
    private String returnStatus;
    private String returnInfo;
    private String jobKey;
    private String dataToken;
    private String secLabel;
    private String spoolTracks;
    private String flagByte;
    private String totallines;
    private String systemEntryDateTime;
    private String programmer;
    private JESJobDataset[] datasets = null;
    private JESJobStep[] jobsteps = null;
    private boolean jobCompleted;
    private boolean jobCommandIssued = false;
    private JMConnection jm;

    public JESJob() {
    }

    public JESJob(JMConnection jm) {
        this.jm = jm;
    }

    public void setStatus(List status) {
        for (String item : status) {
            if (item.startsWith("155-Job.Name=")) {
                this.jobName = item.substring(item.indexOf("=") + 1, item.length());
                continue;
            }
            if (item.startsWith("155-Job.ID=")) {
                this.jobID = item.substring(item.indexOf("=") + 1, item.length());
                continue;
            }
            if (item.startsWith("155-Job.Class=")) {
                this.jobClass = item.substring(item.indexOf("=") + 1, item.length());
                continue;
            }
            if (item.startsWith("155-SYSOUT.Class=")) {
                this.sysoutClass = item.substring(item.indexOf("=") + 1, item.length());
                continue;
            }
            if (item.startsWith("155-Output.Node=")) {
                this.outputNode = item.substring(item.indexOf("=") + 1, item.length());
                continue;
            }
            if (item.startsWith("155-Exec.Node=")) {
                this.execNode = item.substring(item.indexOf("=") + 1, item.length());
                continue;
            }
            if (item.startsWith("155-Job.Owner=")) {
                this.jobOwner = item.substring(item.indexOf("=") + 1, item.length());
                continue;
            }
            if (item.startsWith("155-System.Name=")) {
                this.systemName = item.substring(item.indexOf("=") + 1, item.length());
                continue;
            }
            if (item.startsWith("155-Member.Name=")) {
                this.memberName = item.substring(item.indexOf("=") + 1, item.length());
                continue;
            }
            if (item.startsWith("155-Device.Name=")) {
                this.deviceName = item.substring(item.indexOf("=") + 1, item.length());
                continue;
            }
            if (item.startsWith("155-Job.Phase=")) {
                this.jobPhase = item.substring(item.indexOf("=") + 1, item.length());
                if (this.jobPhase.equals("19") || this.jobPhase.equals("20") || this.jobPhase.equals("21") || this.jobPhase.equals("12") || this.jobPhase.equals("254")) {
                    this.jobCompleted = true;
                    continue;
                }
                this.jobCompleted = false;
                continue;
            }
            if (item.startsWith("155-Hold.Status=")) {
                String holdstatus = item.substring(item.indexOf("=") + 1, item.length());
                if (holdstatus.compareTo("1") == 0) {
                    this.holdStatus = copyright;
                }
                if (holdstatus.compareTo("2") == 0) {
                    this.holdStatus = "HOLD";
                    this.returnStatus = "HOLD";
                    continue;
                }
                if (holdstatus.compareTo("3") != 0) continue;
                this.holdStatus = "DUPLICATE";
                continue;
            }
            if (item.startsWith("155-Job.Type=")) {
                String jobtype = item.substring(item.indexOf("=") + 1, item.length());
                if (jobtype.compareTo("1") == 0) {
                    this.jobType = "STC";
                    continue;
                }
                if (jobtype.compareTo("2") == 0) {
                    this.jobType = "TSU";
                    continue;
                }
                if (jobtype.compareTo("3") == 0) {
                    this.jobType = "JOB";
                    continue;
                }
                if (jobtype.compareTo("4") == 0) {
                    this.jobType = "APPC";
                    continue;
                }
                this.jobType = "unknown";
                continue;
            }
            if (item.startsWith("155-Priority=")) {
                this.priority = item.substring(item.indexOf("=") + 1, item.length());
                continue;
            }
            if (item.startsWith("155-Return.Code=")) {
                Integer decVal;
                String partone = item.substring(18, 19);
                this.returnStatus = partone.compareTo("8") == 0 ? "ABEND" : (partone.compareTo("4") == 0 ? "COMPLETION" : (partone.compareTo("6") == 0 ? "COMPLETION" : copyright));
                String parttwo = item.substring(19, 20);
                if (parttwo.compareTo("0") == 0) {
                    this.returnInfo = "NOINFO";
                } else if (parttwo.compareTo("1") == 0) {
                    this.returnInfo = "NORMAL";
                } else if (parttwo.compareTo("2") == 0) {
                    this.returnInfo = "CC";
                } else if (parttwo.compareTo("3") == 0) {
                    this.returnInfo = "JCLERROR";
                } else if (parttwo.compareTo("4") == 0) {
                    this.returnInfo = "CANCELLED";
                } else if (parttwo.compareTo("5") == 0) {
                    this.returnInfo = "ABENDed";
                } else if (parttwo.compareTo("6") == 0) {
                    this.returnInfo = "ConverterABENDed";
                } else if (parttwo.compareTo("7") == 0) {
                    this.returnInfo = "SECURITYERROR";
                } else if (parttwo.compareTo("8") == 0) {
                    this.returnInfo = "EOMFailure";
                } else if (parttwo.compareTo("9") == 0) {
                    this.returnInfo = "CONV ERROR";
                } else if (parttwo.compareTo("A") == 0) {
                    this.returnInfo = "SYS FAIL";
                } else {
                    this.returnInfo = "UNKNOWN";
                    Logger.getDefault().writeLog("JESJob#setStatus - Return code info back from JES Server - " + item);
                }
                this.systemReturnCode = item.substring(20, 23);
                if (!this.systemReturnCode.equals("000")) {
                    decVal = Integer.valueOf(this.systemReturnCode, 16);
                    int decValu = decVal;
                    String rcS = Integer.toHexString(decValu);
                    rcS = rcS.toUpperCase();
                    while (rcS.length() < 3) {
                        rcS = "0" + rcS;
                    }
                    this.returnCode = "S" + rcS;
                    continue;
                }
                this.userReturnCode = item.substring(23, 26);
                decVal = Integer.valueOf(this.userReturnCode, 16);
                String rcU = String.valueOf(decVal);
                while (rcU.length() < 4) {
                    rcU = "0" + rcU;
                }
                this.returnCode = "U" + rcU;
                continue;
            }
            if (item.startsWith("155-Job.Key=")) {
                this.jobKey = item.substring(item.indexOf("=") + 1, item.length());
                continue;
            }
            if (item.startsWith("155-Data")) continue;
            if (item.startsWith("Token=")) {
                this.dataToken = item.substring(item.indexOf("=") + 1, item.length());
                continue;
            }
            if (item.startsWith("155-Spool.Tracks")) {
                this.spoolTracks = item.substring(item.indexOf("=") + 1, item.length());
                continue;
            }
            if (item.startsWith("155-Sec.Label")) {
                this.secLabel = item.substring(item.indexOf("=") + 1, item.length());
                continue;
            }
            if (item.startsWith("155-flag.byte")) {
                this.flagByte = item.substring(item.indexOf("=") + 1, item.length());
                continue;
            }
            if (item.startsWith("155-Job.SystemEntry")) {
                this.systemEntryDateTime = item.substring(item.indexOf("=") + 1, item.length());
                continue;
            }
            if (item.startsWith("155-Job.Programmer")) {
                this.programmer = item.substring(item.indexOf("=") + 1, item.length());
                continue;
            }
            if (!item.startsWith("155 End of status listing for job")) continue;
        }
    }

    public String getNumberofDatasets() {
        if (this.datasets == null) {
            return "0";
        }
        Integer length = new Integer(this.datasets.length);
        return length.toString();
    }

    public String getTotalLines() {
        int totalLines = 0;
        if (this.datasets == null) {
            return "0";
        }
        for (int i = 0; i < this.datasets.length; ++i) {
            totalLines += Integer.parseInt(this.datasets[i].getLineCount());
        }
        return String.valueOf(totalLines);
    }

    public void setDatasets(JESJobDataset[] dataSets) {
        this.datasets = dataSets;
    }

    public JESJobDataset[] getDatasets() {
        if (this.datasets == null) {
            JMConnection jm = this.getJMConnection();
            ArrayList<String> results = null;
            this.datasets = new JESJobDataset[0];
            try {
                results = jm.sysout(this.jobID);
                this.datasets = this.getDatasets(results);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.datasets;
    }

    public JESJobDataset[] getDatasets(List<?> results) {
        if (results != null) {
            int i = 0;
            Iterator<?> iter = results.iterator();
            this.datasets = new JESJobDataset[results.size()];
            JMConnection jm = this.getJMConnection();
            if (jm != null) {
                JmonProtocol protocol = jm.getProtocolLevel();
                if (protocol != null && !protocol.isEarlierThan(IJESMinerConstants.procStepAndDSIDSupportedProtocol)) {
                    while (iter.hasNext()) {
                        JESJobDataset dataset = new JESJobDataset();
                        String ds = (String)iter.next();
                        String[] temp = ds.split("[\\s]+");
                        switch (temp.length) {
                            case 8: {
                                dataset.setTime(temp[7].substring(5));
                            }
                            case 7: {
                                dataset.setDate(temp[6].substring(5));
                            }
                            case 6: {
                                dataset.setLineCount(temp[5].substring(8));
                            }
                            case 5: {
                                String dsID = temp[4].substring(5);
                                Integer intDSID = new Integer(dsID);
                                dataset.setDataSetID(intDSID);
                            }
                            case 4: {
                                dataset.setProcStepName(temp[3].substring(5));
                            }
                            case 3: {
                                dataset.setStepName(temp[2].substring(5));
                            }
                            case 2: {
                                dataset.setDDName(temp[1].substring(3));
                                dataset.setDsName(temp[0].substring(4));
                                break;
                            }
                        }
                        dataset.setJobId(this.jobID);
                        dataset.setJob(this);
                        this.datasets[i++] = dataset;
                        if (!dataset.getDDName().equals("JESYSMSG")) continue;
                        this.jobsteps = this.getJobStepInfo(dataset);
                        if (this.jobsteps == null) continue;
                        this.setJobSteps(this.jobsteps);
                    }
                } else {
                    while (iter.hasNext()) {
                        JESJobDataset dataset = new JESJobDataset();
                        String ds = (String)iter.next();
                        String[] temp = ds.split("[\\s]+");
                        switch (temp.length) {
                            case 6: {
                                dataset.setTime(temp[5].substring(5));
                            }
                            case 5: {
                                dataset.setDate(temp[4].substring(5));
                            }
                            case 4: {
                                dataset.setLineCount(temp[3].substring(8));
                            }
                            case 3: {
                                dataset.setStepName(temp[2].substring(5));
                            }
                            case 2: {
                                dataset.setDDName(temp[1].substring(3));
                                dataset.setDsName(temp[0].substring(4));
                                break;
                            }
                        }
                        dataset.setJobId(this.jobID);
                        dataset.setJob(this);
                        this.datasets[i++] = dataset;
                        if (!dataset.getDDName().equals("JESYSMSG")) continue;
                        this.jobsteps = this.getJobStepInfo(dataset);
                        if (this.jobsteps == null) continue;
                        this.setJobSteps(this.jobsteps);
                    }
                }
            }
        }
        this.pushStepReturnCodeToJobDataSets(this.datasets, this.jobsteps);
        return this.datasets;
    }

    private JMConnection getJMConnection() {
        return this.jm;
    }

    public String getDataToken() {
        return this.dataToken;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getExecNode() {
        return this.execNode;
    }

    public String getHoldStatus() {
        return this.holdStatus;
    }

    public String getJobClass() {
        return this.jobClass;
    }

    public String getJobID() {
        return this.jobID;
    }

    public String getJobKey() {
        return this.jobKey;
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getJobOwner() {
        return this.jobOwner;
    }

    public String getJobPhase() {
        return this.jobPhase;
    }

    public String getJobType() {
        return this.jobType;
    }

    public String getMemberName() {
        return this.memberName;
    }

    public String getOutputNode() {
        return this.outputNode;
    }

    public String getPriority() {
        return this.priority;
    }

    public String getReturnCode() {
        return this.returnCode;
    }

    public String getReturnInfo() {
        return this.returnInfo;
    }

    public String getReturnStatus() {
        return this.returnStatus;
    }

    public String getSpoolTracks() {
        return this.spoolTracks;
    }

    public String getSysoutClass() {
        return this.sysoutClass;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public String getSystemReturnCode() {
        return this.systemReturnCode;
    }

    public String getUserReturnCode() {
        return this.userReturnCode;
    }

    public void setDataToken(String string) {
        this.dataToken = string;
    }

    public void setDeviceName(String string) {
        this.deviceName = string;
    }

    public void setExecNode(String string) {
        this.execNode = string;
    }

    public void setHoldStatus(String string) {
        this.holdStatus = string;
    }

    public void setJobClass(String string) {
        this.jobClass = string;
    }

    public void setJobID(String string) {
        this.jobID = string;
    }

    public void setJobKey(String string) {
        this.jobKey = string;
    }

    public void setJobName(String string) {
        this.jobName = string;
    }

    public void setJobOwner(String string) {
        this.jobOwner = string;
    }

    public void setJobPhase(String string) {
        this.jobPhase = string;
    }

    public void setJobType(String string) {
        this.jobType = string;
    }

    public void setMemberName(String string) {
        this.memberName = string;
    }

    public void setOutputNode(String string) {
        this.outputNode = string;
    }

    public void setPriority(String string) {
        this.priority = string;
    }

    public void setReturnCode(String string) {
        this.returnCode = string;
    }

    public void setReturnInfo(String string) {
        this.returnInfo = string;
    }

    public void setReturnStatus(String string) {
        this.returnStatus = string;
    }

    public void setSpoolTracks(String string) {
        this.spoolTracks = string;
    }

    public void setSysoutClass(String string) {
        this.sysoutClass = string;
    }

    public void setSystemName(String string) {
        this.systemName = string;
    }

    public void setSystemReturnCode(String string) {
        this.systemReturnCode = string;
    }

    public void setUserReturnCode(String string) {
        this.userReturnCode = string;
    }

    public String getSecLabel() {
        return this.secLabel;
    }

    public void setSecLabel(String label) {
        this.secLabel = label;
    }

    public String getFlagByte() {
        return this.flagByte;
    }

    public void setFlagByte(String string) {
        this.flagByte = string;
    }

    public String getSystemEntryDateTime() {
        return this.systemEntryDateTime;
    }

    public void setSystemEntryDateTime(String datetime) {
        datetime = this.systemEntryDateTime;
    }

    public String getProgrammer() {
        return this.programmer;
    }

    public void setProgrammer(String name) {
        this.programmer = name;
    }

    public boolean getJobCompleted() {
        return this.jobCompleted;
    }

    public void setJobCompleted(boolean done) {
        this.jobCompleted = done;
    }

    public void setJobCommandIssued(boolean commandIssued) {
        this.jobCommandIssued = commandIssued;
    }

    public boolean isJobCommandIssued() {
        return this.jobCommandIssued;
    }

    protected JESJobStep[] getJobStepInfo(JESJobDataset jobDataSet) {
        Vector<JESJobStep> v = new Vector<JESJobStep>();
        JMConnection jm = this.getJMConnection();
        int cutOff = Integer.MAX_VALUE;
        String jobId = jobDataSet.getJobId();
        String dsName = jobDataSet.getdsName();
        try {
            InputStream spoolDatasetStream = jm.getOutputSDS(jobId, dsName, cutOff);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(spoolDatasetStream));
            boolean nextLineRead = false;
            boolean foundEnd = false;
            String s = null;
            String jobName = copyright;
            String procStep = copyright;
            String stepName = copyright;
            String returnCode = copyright;
            while (!foundEnd) {
                if (!nextLineRead && (s = bufferedReader.readLine()) == null) {
                    foundEnd = true;
                }
                if (s == null) continue;
                nextLineRead = false;
                if (s.indexOf("IEF142I") != 0) continue;
                jobName = copyright;
                procStep = copyright;
                stepName = copyright;
                returnCode = copyright;
                StringTokenizer st = new StringTokenizer(s, " -");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (!token.equalsIgnoreCase("IEF142I")) continue;
                    jobName = st.nextToken();
                    stepName = st.nextToken();
                    token = st.nextToken();
                    if (!token.equals("STEP")) {
                        procStep = stepName;
                        stepName = token;
                        st.nextToken();
                    }
                    st.nextToken();
                    st.nextToken();
                    st.nextToken();
                    st.nextToken();
                    returnCode = st.nextToken();
                }
                if (stepName.equals(copyright) || returnCode.equals(copyright)) continue;
                JESJobStep jesJobStep = new JESJobStep();
                jesJobStep.setStepName(stepName);
                jesJobStep.setStepReturnCode(returnCode);
                v.add(jesJobStep);
            }
            bufferedReader.close();
        }
        catch (Exception e) {
            Logger.getDefault().writeError(e.getMessage(), e);
            e.printStackTrace();
        }
        if (v.size() > 0) {
            this.jobsteps = new JESJobStep[v.size()];
            v.copyInto(this.jobsteps);
        }
        return this.jobsteps;
    }

    public JESJobStep[] getJobSteps() {
        return this.jobsteps;
    }

    protected void setJobSteps(JESJobStep[] steps) {
        this.jobsteps = steps;
    }

    protected void pushStepReturnCodeToJobDataSets(JESJobDataset[] datasets, JESJobStep[] steps) {
        int datasetCount;
        if (datasets != null && steps != null && (datasetCount = datasets.length) > 0) {
            for (int i = 0; i < datasetCount; ++i) {
                JESJobDataset jobDataSet = datasets[i];
                String stepName = jobDataSet.getStepName();
                String stepReturnCode = this.getStepReturnCode(steps, stepName);
                if (stepReturnCode == null) continue;
                jobDataSet.setStepReturnCode(stepReturnCode);
            }
        }
    }

    private String getStepReturnCode(JESJobStep[] steps, String stepName) {
        String result = null;
        if (steps != null) {
            for (int i = 0; i < steps.length; ++i) {
                JESJobStep jobStep = steps[i];
                String name = jobStep.getStepName();
                if (!name.equalsIgnoreCase(stepName)) continue;
                result = jobStep.getStepReturnCode();
                return result;
            }
        }
        return result;
    }

    public String toString() {
        return "JESJob [jobName=" + this.jobName + ", jobID=" + this.jobID + ", jobClass=" + this.jobClass + ", sysoutClass=" + this.sysoutClass + ", outputNode=" + this.outputNode + ", execNode=" + this.execNode + ", jobOwner=" + this.jobOwner + ", systemName=" + this.systemName + ", memberName=" + this.memberName + ", deviceName=" + this.deviceName + ", jobPhase=" + this.jobPhase + ", holdStatus=" + this.holdStatus + ", jobType=" + this.jobType + ", priority=" + this.priority + ", returnCode=" + this.returnCode + ", systemReturnCode=" + this.systemReturnCode + ", userReturnCode=" + this.userReturnCode + ", returnStatus=" + this.returnStatus + ", returnInfo=" + this.returnInfo + ", jobKey=" + this.jobKey + ", dataToken=" + this.dataToken + ", secLabel=" + this.secLabel + ", spoolTracks=" + this.spoolTracks + ", flagByte=" + this.flagByte + ", totallines=" + this.totallines + ", systemEntryDateTime=" + this.systemEntryDateTime + ", programmer=" + this.programmer + ", datasets=" + Arrays.toString(this.datasets) + ", jobsteps=" + Arrays.toString(this.jobsteps) + ", jobCompleted=" + this.jobCompleted + ", jobCommandIssued=" + this.jobCommandIssued + ", getNumberofDatasets()=" + this.getNumberofDatasets() + ", getTotalLines()=" + this.getTotalLines() + ", getDatasets()=" + Arrays.toString(this.getDatasets()) + ", getJMConnection()=" + this.getJMConnection() + ", getDataToken()=" + this.getDataToken() + ", getDeviceName()=" + this.getDeviceName() + ", getExecNode()=" + this.getExecNode() + ", getHoldStatus()=" + this.getHoldStatus() + ", getJobClass()=" + this.getJobClass() + ", getJobID()=" + this.getJobID() + ", getJobKey()=" + this.getJobKey() + ", getJobName()=" + this.getJobName() + ", getJobOwner()=" + this.getJobOwner() + ", getJobPhase()=" + this.getJobPhase() + ", getJobType()=" + this.getJobType() + ", getMemberName()=" + this.getMemberName() + ", getOutputNode()=" + this.getOutputNode() + ", getPriority()=" + this.getPriority() + ", getReturnCode()=" + this.getReturnCode() + ", getReturnInfo()=" + this.getReturnInfo() + ", getReturnStatus()=" + this.getReturnStatus() + ", getSpoolTracks()=" + this.getSpoolTracks() + ", getSysoutClass()=" + this.getSysoutClass() + ", getSystemName()=" + this.getSystemName() + ", getSystemReturnCode()=" + this.getSystemReturnCode() + ", getUserReturnCode()=" + this.getUserReturnCode() + ", getSecLabel()=" + this.getSecLabel() + ", getFlagByte()=" + this.getFlagByte() + ", getSystemEntryDateTime()=" + this.getSystemEntryDateTime() + ", getProgrammer()=" + this.getProgrammer() + ", getJobCompleted()=" + this.getJobCompleted() + ", isJobCommandIssued()=" + this.isJobCommandIssued() + ", getJobSteps()=" + Arrays.toString(this.getJobSteps()) + ", getClass()=" + this.getClass() + ", hashCode()=" + this.hashCode() + ", toString()=" + super.toString() + "]";
    }

    public class JESJobStep {
        public String stepName;
        public String stepReturnCode;

        public String getStepName() {
            return this.stepName;
        }

        public void setStepName(String name) {
            this.stepName = name;
        }

        public String getStepReturnCode() {
            return this.stepReturnCode;
        }

        public void setStepReturnCode(String returnCode) {
            this.stepReturnCode = returnCode;
        }
    }
}

