/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.jes;

import com.ibm.urbancode.zos.jes.JESJob;
import com.ibm.urbancode.zos.jes.JESJobDataset;
import com.ibm.urbancode.zos.jes.JMConnection;
import com.ibm.urbancode.zos.jes.JMException;
import com.ibm.urbancode.zos.jes.Logger;
import com.ibm.urbancode.zos.jes.SystemMessageException;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class JobUtil {
    String host;
    String port;
    String userid;
    String password;
    boolean useRunId;
    int cutoff = 1000;
    int timeout = 10;
    int interval = 2;
    int maxReturnCode = 4;
    String mvsFilename = null;
    String ussFilename = null;
    String jclString = null;
    String showOutput = "ALL";
    int returnCode = -1;
    JMConnection jm = null;
    JESJob latestJob = null;
    Logger logger = Logger.getDefault();

    public String[] getShowOutput() {
        String[] split = this.showOutput.split(",");
        for (int i = 0; i < split.length; ++i) {
            split[i] = split[i].trim().toUpperCase();
        }
        return split;
    }

    public void setShowOutput(String showOutput) {
        this.showOutput = showOutput;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getCutoff() {
        return this.cutoff;
    }

    public void setCutoff(int cutoff) {
        this.cutoff = cutoff;
    }

    public int getMaxReturnCode() {
        return this.maxReturnCode;
    }

    public void setMaxReturnCode(int maxReturnCode) {
        this.maxReturnCode = maxReturnCode;
    }

    public String getMvsFilename() {
        return this.mvsFilename;
    }

    private void clearJclInputs() {
        this.ussFilename = null;
        this.jclString = null;
        this.mvsFilename = null;
    }

    public void setMvsFilename(String mvsFilename) {
        this.clearJclInputs();
        this.mvsFilename = mvsFilename;
    }

    public String getUssFilename() {
        return this.ussFilename;
    }

    public void setUssFilename(String ussFilename) {
        this.clearJclInputs();
        this.ussFilename = ussFilename;
    }

    public String getJclString() {
        return this.jclString;
    }

    public void setJclString(String jclString) {
        this.clearJclInputs();
        this.jclString = jclString;
    }

    public void setPassword(String newPassword) throws SystemMessageException {
        this.password = newPassword;
        if (this.jm == null) {
            this.jm = new JMConnection();
            this.jm.setUseRunId(this.useRunId);
        }
        this.jm.connect(this.host, this.port, this.userid, this.password);
    }

    public JobUtil(String host, String port, String userid, String password, boolean useRunId) {
        this.host = host;
        this.port = port;
        this.userid = userid;
        this.password = password;
        this.useRunId = useRunId;
    }

    public JobUtil(String host, String port, String userid, String password) {
        this.host = host;
        this.port = port;
        this.userid = userid;
        this.password = password;
        this.useRunId = false;
    }

    private JMConnection getJm() throws SystemMessageException {
        if (this.jm == null) {
            this.jm = new JMConnection();
            this.jm.setUseRunId(this.useRunId);
            this.jm.connect(this.host, this.port, this.userid, this.password);
        }
        return this.jm;
    }

    private String submitJobDS(String mvsName) throws Exception {
        String response = this.getJm().submitDs(mvsName);
        String jobid = response.split(" ")[1];
        return jobid;
    }

    private String submitJob(File ussFile) throws Exception {
        String response = this.getJm().submit(ussFile);
        String jobid = response.split(" ")[1];
        return jobid;
    }

    private String submitJob(String jclString) throws Exception {
        String response = this.getJm().submit(jclString);
        String jobid = response.split(" ")[1];
        return jobid;
    }

    public JESJob getJob(String jobid, boolean useCache) throws JMException, SystemMessageException {
        if (useCache && this.latestJob != null) {
            return this.latestJob;
        }
        ArrayList<String> status = this.getJm().getStatus(jobid);
        if (status != null) {
            JESJob job = new JESJob(this.getJm());
            job.setJobID(jobid);
            job.setStatus(status);
            this.latestJob = job;
            return job;
        }
        throw new JMException("Failed to get status for job " + jobid);
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    private void printOutputSDS(JESJobDataset dataset) throws SystemMessageException, Exception {
        String line;
        InputStream outputSDS = this.getJm().getOutputSDS(dataset.getJobId(), dataset.getdsName(), this.cutoff);
        String datasetDescription = dataset.getdsName() + "  DD=" + dataset.getDDName() + "  LineCnt=" + dataset.getLineCount() + "  Date=" + dataset.getDate() + "  Time=" + dataset.getTime();
        BufferedReader reader = new BufferedReader(new InputStreamReader(outputSDS));
        this.logger.writeLog("========================================================================================================================");
        this.logger.writeLog(datasetDescription);
        this.logger.writeLog("========================================================================================================================");
        while ((line = reader.readLine()) != null) {
            this.logger.writeLog(line);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String submitJob() throws Exception {
        String jobid = null;
        if (this.getMvsFilename() != null) {
            return this.submitJobDS(this.getMvsFilename());
        }
        if (this.getUssFilename() != null) {
            File jclFile = new File(this.getUssFilename());
            if (!jclFile.exists()) throw new JMException("JCL file not found. " + jclFile.getAbsolutePath());
            if (!jclFile.canRead()) throw new JMException("JCL file not found. " + jclFile.getAbsolutePath());
            return this.submitJob(jclFile);
        }
        if (this.getJclString() == null) throw new JMException("JCL input not found. ");
        return this.submitJob(this.getJclString());
    }

    public boolean isJclError(String jobid) throws Exception {
        if (jobid == null) {
            throw new JMException("jobid is null");
        }
        JESJob job = this.getJob(jobid, false);
        if (job != null) {
            if (job.getJobCompleted() && "JCLERROR".equals(job.getReturnInfo())) {
                JESJobDataset[] datasets;
                this.logger.writeLog("JCL Error.");
                for (JESJobDataset dataset : datasets = job.getDatasets()) {
                    this.logger.writeDebug("printing ds=" + dataset.getdsName());
                    this.printOutputSDS(dataset);
                }
                return true;
            }
            return false;
        }
        throw new Exception("Failed to get job status.");
    }

    public void printLog(String jobid) throws Exception {
        if (jobid == null) {
            throw new JMException("jobid is null");
        }
        JESJob job = this.getJob(jobid, true);
        if (job != null) {
            JESJobDataset[] datasets = job.getDatasets();
            String[] dsNameList = this.getShowOutput();
            boolean showAll = false;
            for (String dsName : dsNameList) {
                if (!"ALL".equals(dsName)) continue;
                showAll = true;
                break;
            }
            for (JESJobDataset dataset : datasets) {
                if (showAll) {
                    this.printOutputSDS(dataset);
                    continue;
                }
                for (String dsName : dsNameList) {
                    if (!dataset.getDDName().equalsIgnoreCase(dsName)) continue;
                    this.printOutputSDS(dataset);
                }
            }
        } else {
            throw new JMException("Failed to get job status.");
        }
    }

    public boolean waitForJob(String jobid) throws Exception {
        if (jobid == null) {
            throw new Exception("jobid is null");
        }
        for (int elapse = 0; elapse < this.timeout; elapse += this.interval) {
            JESJob job = this.getJob(jobid, false);
            if (job != null) {
                if (job.getJobCompleted()) {
                    int intCode;
                    this.logger.writeLog("Job Completed");
                    this.logger.writeLog("JobID=" + job.getJobID());
                    this.logger.writeLog("JobName=" + job.getJobName());
                    this.logger.writeLog("JobReturnCode=" + job.getReturnCode());
                    this.logger.writeLog("JobReturnInfo=" + job.getReturnInfo());
                    this.logger.writeLog("JobReturnStatus=" + job.getReturnStatus());
                    String returnCode = job.getReturnCode();
                    returnCode = returnCode.substring(1);
                    this.returnCode = intCode = Integer.parseInt(returnCode);
                    if (this.maxReturnCode >= 0) {
                        if ("COMPLETION".equals(job.getReturnStatus())) {
                            return intCode <= this.maxReturnCode;
                        }
                        this.logger.writeLog("Job does not end with completion code.");
                        return false;
                    }
                    if ("COMPLETION".equals(job.getReturnStatus())) {
                        this.logger.writeLog("Job completed successfully.");
                        return true;
                    }
                    this.logger.writeLog("Job does not end with completion status..");
                    return false;
                }
            } else {
                throw new JMException("Failed to get job status.");
            }
            this.logger.writeDebug("Waiting... " + this.interval);
            Thread.sleep(this.interval * 1000);
        }
        this.logger.writeLog("Timeout waiting for job to complete. Timeout=" + this.timeout + " seconds.");
        return false;
    }

    public void disconnect() {
        if (this.jm != null) {
            try {
                this.jm.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return "JobUtil [host=" + this.host + ", port=" + this.port + ", userid=" + this.userid + ", password=" + this.password + ", cutoff=" + this.cutoff + ", timeout=" + this.timeout + ", interval=" + this.interval + ", maxReturnCode=" + this.maxReturnCode + ", mvsFilename=" + this.mvsFilename + ", ussFilename=" + this.ussFilename + ", jclString=" + this.jclString + ", showOutput=" + this.showOutput + ", returnCode=" + this.returnCode + "]";
    }
}

