#!/bin/sh
# *********************************************************************
# * Licensed materials - Property of IBM                              *
# *     UrbanCode Deploy                                              *
# * (c) Copyright IBM Corporation 2011, 2014. All Rights Reserved.    *
# * (c) Copyright HCL Technologies Ltd. 2022. All Rights Reserved.    *
# * US Government users restricted rights  -  Use, duplication or     *
# * disclosure restricted by GSA ADP schedule contract with IBM Corp. *
# *                                                                   *
# *********************************************************************
# *
# * This shell script is used to invoke the ISPF Gateway
# *
# * BUZ_CFG must be set to the configuration directory. The directory
# * contains ISPF.conf, buzenv.sh and other configuration files to
# * run the UrbanCode Deploy z/OS toolkit
# *********************************************************************
#
# run buzenv.sh to set environment variables

export ISPF_LOG_DIR="`pwd`"
LOG_ISPF="`pwd`"/LOGISPF.$$
echo "<?xml version=\"1.0\"?>
<ISPF-INPUT>
<SERVICE-REQUEST>
<service>ISPF</service>
<session>NONE</session>
<command>TSO EX '$1'</command>
</SERVICE-REQUEST>
</ISPF-INPUT>" | ISPZXML >"$LOG_ISPF"
rc=0

grep  "The initially invoked CLIST ended with a return code =" "$LOG_ISPF">/dev/null
if [ $? -eq 0 ]
then
        rc=1
else
    grep  "<RETURN-CODE>" "$LOG_ISPF">/dev/null
    if [ $? -eq 0 ]
    then
                # Check RETURN CODE
        a=`sed -n -e 's/<RETURN-CODE>\(.*\)<.*/\1/p' "$LOG_ISPF"| sed -e '1 q'`
        if test $a != 0
            then
                    rc=3
        fi
    else
      echo "The ISPF gateway is not configured correctly."
      rc=2
    fi
fi
if [ $rc -gt 1 ]
then
        cat "$LOG_ISPF"
else
        ispfout=0
        cat "$LOG_ISPF"| while read line
        do
                if [ "]]>" = "$line" ]; then break; fi
                if [ $ispfout -eq 1 ]; then echo "$line"; fi
                if [ "<![CDATA[" = "$line" ]; then ispfout=1; fi
        done
fi

rm "$LOG_ISPF"
exit $rc