/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.inputs;

import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZFileException;
import com.urbancode.air.plugin.command.utils.DatasetException;
import com.urbancode.air.plugin.command.utils.MissingInputException;
import java.util.Properties;

public class PluginInputs {
    public static final String SOURCE_TYPE = "sourceType";
    public static final String SOURCE_VALUE = "sourceValue";
    public static final String SYSPROC_DATASETS = "sysprocDatasets";
    public static final String ARGUMENTS = "rexxArguments";
    public static final String TEMP_DSN_PREFIX = "tempDsnPrefix";
    public static final String ISPF_GATEWAY_PATH = "ispfGatewayPath";
    public static final String PRINT_DEBUG_LOGS = "printDebugLogs";
    private static final String DATASET = "DATASET";
    public static final String SINGLE_QUOTE = "'";
    private final String sourceType;
    private final String sourceValue;
    private final String sysprocDatasets;
    private final String rexxArguments;
    private final String dsnPrefix;
    private final String ispfGatewayPath;
    private final boolean isDebugEnabled;

    public PluginInputs(Properties inputProperties) {
        this.sourceType = inputProperties.getProperty(SOURCE_TYPE);
        this.sourceValue = this.isSourceTypeDataset() ? this.getFullyQualifiedSourceDataset(inputProperties.getProperty(SOURCE_VALUE).trim().toUpperCase()) : inputProperties.getProperty(SOURCE_VALUE);
        this.sysprocDatasets = inputProperties.getProperty(SYSPROC_DATASETS).trim().toUpperCase();
        this.rexxArguments = this.encloseArgumentsInSingleQuotes(inputProperties.getProperty(ARGUMENTS).trim());
        String inputDsnPrefix = inputProperties.getProperty(TEMP_DSN_PREFIX).trim();
        this.dsnPrefix = inputDsnPrefix.isEmpty() ? ZFile.getDefaultHLQ() : inputDsnPrefix.toUpperCase();
        this.ispfGatewayPath = inputProperties.getProperty(ISPF_GATEWAY_PATH).trim();
        this.isDebugEnabled = Boolean.parseBoolean(inputProperties.getProperty(PRINT_DEBUG_LOGS));
    }

    private String getFullyQualifiedSourceDataset(String sourceValue) {
        return sourceValue.startsWith(SINGLE_QUOTE) ? sourceValue : SINGLE_QUOTE + ZFile.getFullyQualifiedDSN(sourceValue, false) + SINGLE_QUOTE;
    }

    public void validateInputs() throws ZFileException {
        if (this.sourceValue.isEmpty()) {
            throw new MissingInputException(" [Error] Source value is mandatory.");
        }
        if (this.ispfGatewayPath.isEmpty()) {
            throw new MissingInputException(" [Error] ISPF Gateway path is mandatory.");
        }
        if (this.isSourceTypeDataset()) {
            this.checkIfDatasetExist();
        }
    }

    private void checkIfDatasetExist() throws ZFileException {
        if (!ZFile.dsExists(this.sourceValue)) {
            throw new DatasetException(" [Error] " + this.sourceValue + " doesn't exists.");
        }
    }

    private String encloseArgumentsInSingleQuotes(String arguments) {
        String enclosedArguments = "";
        if (!arguments.isEmpty()) {
            enclosedArguments = arguments.startsWith(SINGLE_QUOTE) ? arguments : SINGLE_QUOTE + arguments + SINGLE_QUOTE;
        }
        return enclosedArguments;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public String getSourceValue() {
        return this.sourceValue;
    }

    public String getSysprocDatasets() {
        return this.sysprocDatasets;
    }

    public String getRexxArguments() {
        return this.rexxArguments;
    }

    public String getDsnPrefix() {
        return this.dsnPrefix;
    }

    public String getIspfGatewayPath() {
        return this.ispfGatewayPath;
    }

    private boolean isSourceTypeDataset() {
        return this.sourceType.equals(DATASET);
    }

    public boolean isDebugEnabled() {
        return this.isDebugEnabled;
    }
}

