/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.UnsupportedCharsetException;

public class Transcoder {
    private Charset sourceCharset;
    private CharsetDecoder decoder;
    private Charset targetCharset;
    private CharsetEncoder encoder;
    private ByteBuffer byteBuffer;
    private CharBuffer charBuffer;
    private OutputStreamWriter encodingWriter;
    private boolean autoFlush;

    public Transcoder(String sourceEncoding, String targetEncoding, OutputStream outputStream) throws UnsupportedCharsetException {
        this(sourceEncoding, targetEncoding, outputStream, 1024, 1024, false);
    }

    public Transcoder(String sourceEncoding, String targetEncoding, OutputStream outputStream, int byteBufferSize, int charBufferSize, boolean autoFlush) throws UnsupportedCharsetException {
        this.sourceCharset = Charset.forName(sourceEncoding);
        this.decoder = this.sourceCharset.newDecoder();
        this.decoder.onMalformedInput(CodingErrorAction.REPLACE);
        this.decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.targetCharset = Charset.forName(targetEncoding);
        this.encoder = this.targetCharset.newEncoder();
        this.encoder.onMalformedInput(CodingErrorAction.REPLACE);
        this.encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.encodingWriter = new OutputStreamWriter(outputStream, this.encoder);
        this.byteBuffer = ByteBuffer.allocateDirect(byteBufferSize);
        this.charBuffer = CharBuffer.allocate(charBufferSize);
        this.autoFlush = autoFlush;
    }

    public void translate(byte[] bytes) throws IOException {
        this.translate(bytes, 0, bytes.length);
    }

    public void translate(byte[] bytes, int offset, int length) throws IOException {
        int len;
        for (int bytesProcessed = 0; bytesProcessed < length; bytesProcessed += len) {
            len = Math.min(this.byteBuffer.remaining(), length - bytesProcessed);
            this.byteBuffer.put(bytes, offset + bytesProcessed, len);
            this.byteBuffer.flip();
            CoderResult result = null;
            do {
                result = this.decoder.decode(this.byteBuffer, this.charBuffer, false);
                this.charBuffer.flip();
                this.encodingWriter.write(this.charBuffer.array(), this.charBuffer.position(), this.charBuffer.length());
                this.charBuffer.clear();
            } while (!result.isUnderflow());
            this.byteBuffer.compact();
        }
        if (this.autoFlush) {
            this.flush();
        }
    }

    public CharsetDecoder getDecoder() {
        return this.decoder;
    }

    public CharsetEncoder getEncoder() {
        return this.encoder;
    }

    public void flush() throws IOException {
        this.encodingWriter.flush();
    }

    public void reset() throws IOException {
        this.decoder.reset();
        this.decoder.flush(this.charBuffer);
        this.encodingWriter.write(this.charBuffer.array(), this.charBuffer.position(), this.charBuffer.length());
        this.encodingWriter.flush();
        this.encoder.reset();
    }

    public boolean isAutoFlush() {
        return this.autoFlush;
    }

    public void setAutoFlush(boolean autoFlush) {
        this.autoFlush = autoFlush;
    }

    public Charset getSourceCharset() {
        return this.sourceCharset;
    }

    public Charset getTargetCharset() {
        return this.targetCharset;
    }
}

