/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.ispf.gateway.common;

import com.ibm.urbancode.zos.ispf.gateway.common.IspfGatewayException;
import com.ibm.urbancode.zos.ispf.gateway.common.IspfGatewayXMLInput;
import com.ibm.urbancode.zos.ispf.gateway.common.IspfGatewayXMLResponse;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class IspfGatewayExecutor {
    private static final String ISPZXML = "ISPZXML";
    private static final String XML_VERSION = "<?xml version";
    private final String xmlInput;
    private final String ispzxmlFilePath;
    private final HashMap<String, String> environmentVars = new HashMap();
    private boolean printLogs = false;

    public IspfGatewayExecutor(String ispfGatewayPath, IspfGatewayXMLInput ispfGatewayXMLInput) {
        this.xmlInput = ispfGatewayXMLInput.getIspfInputXml();
        this.ispzxmlFilePath = ispfGatewayPath + File.separator + ISPZXML;
    }

    public IspfGatewayExecutor(String ispfGatewayPath, IspfGatewayXMLInput ispfGatewayXMLInput, boolean printLogs) {
        this(ispfGatewayPath, ispfGatewayXMLInput);
        this.printLogs = printLogs;
    }

    public void setEnvironmentVars(HashMap<String, String> environmentVars) {
        this.environmentVars.putAll(environmentVars);
    }

    public IspfGatewayXMLResponse execute() throws IOException, InterruptedException, ParserConfigurationException, SAXException {
        this.validateIspzxmlFile();
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(this.ispzxmlFilePath);
        ProcessBuilder processBuilder = new ProcessBuilder(commandLine);
        processBuilder.environment().putAll(this.environmentVars);
        Process process = processBuilder.start();
        this.passInput(process);
        process.getOutputStream().close();
        StringBuilder processResponse = this.readProcessOutputBuffer(process);
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            System.out.println("===============================");
            System.out.println("STDOUT:- ");
            System.out.println(processResponse);
            this.printFromErrorStream(process);
            throw new RuntimeException(" [Error] ISPF Gateway Executor Process failed with code " + exitCode);
        }
        return this.getGatewayResponseFromProcess(processResponse);
    }

    private StringBuilder readProcessOutputBuffer(Process process) throws IOException {
        StringBuilder response = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String responseLine;
            while ((responseLine = reader.readLine()) != null) {
                if (!this.isNotConnectionProtocol(responseLine)) continue;
                response.append(responseLine).append(System.lineSeparator());
            }
            StringBuilder stringBuilder = response;
            return stringBuilder;
        }
    }

    private void validateIspzxmlFile() {
        File ispzxmlFile = new File(this.ispzxmlFilePath);
        if (!ispzxmlFile.isFile()) {
            throw new RuntimeException(" [Error] " + this.ispzxmlFilePath + " file does not exist.");
        }
        if (!ispzxmlFile.canExecute() || !ispzxmlFile.canRead()) {
            throw new RuntimeException(" [Error] " + this.ispzxmlFilePath + " file does not have Execute and Read permission.");
        }
    }

    private void passInput(Process process) {
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(process.getOutputStream()));
        printWriter.print(this.xmlInput);
        printWriter.flush();
    }

    private void printFromErrorStream(Process process) throws IOException {
        System.out.println("===============================");
        System.out.println("STDERR:- ");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));){
            String outputLine;
            while ((outputLine = reader.readLine()) != null) {
                System.out.println(outputLine);
            }
        }
    }

    private IspfGatewayXMLResponse getGatewayResponseFromProcess(StringBuilder processResponse) throws IOException, ParserConfigurationException, SAXException {
        String outputXml = processResponse.toString();
        int xmlTagPosition = outputXml.indexOf(XML_VERSION);
        if (xmlTagPosition == -1) {
            throw new IspfGatewayException("Failed to get response XML from ISPF Gateway.");
        }
        outputXml = outputXml.substring(xmlTagPosition);
        if (this.printLogs) {
            this.printDebugLogs(outputXml);
        }
        return this.parseXML(outputXml);
    }

    private void printDebugLogs(String outputXml) {
        System.out.println("===============================");
        System.out.println("Response XML");
        System.out.println(outputXml);
        System.out.println("===============================");
    }

    private boolean isNotConnectionProtocol(String line) {
        return !line.trim().startsWith("Connection Protocol");
    }

    private IspfGatewayXMLResponse parseXML(String outputXml) throws ParserConfigurationException, SAXException, IOException {
        IspfGatewayXMLResponse xmlHandler = new IspfGatewayXMLResponse();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        saxParser.parse(new InputSource(new StringReader(outputXml)), (DefaultHandler)xmlHandler);
        return xmlHandler;
    }
}

