/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.ispf.gateway.common;

public class IspfGatewayXMLInput {
    private static final String SERVICE_TYPE_ISPF = "ISPF";
    private static final String SERVICE_TYPE_TSO = "TSO";
    private static final String SESSION_NONE = "NONE";
    private static final String SESSION_REUSE = "REUSE";
    private static final String NEW_LINE = System.lineSeparator();
    private final String serviceType;
    private final String command;
    private String session = "NONE";
    private String ispProf = null;

    public IspfGatewayXMLInput(String serviceType, String command) {
        if (!serviceType.equals(SERVICE_TYPE_ISPF) && !serviceType.equals(SERVICE_TYPE_TSO)) {
            throw new IllegalArgumentException("Invalid Service Type found for ISPF input - " + serviceType);
        }
        this.serviceType = serviceType;
        this.command = command;
    }

    public void setSession(String session) {
        if (!session.equals(SESSION_NONE) && !session.equals(SESSION_REUSE)) {
            throw new IllegalArgumentException("Invalid Session found for ISPF input - " + session);
        }
        this.session = session;
    }

    public void setIspProf(String ispProf) {
        this.ispProf = ispProf;
    }

    public String getIspfInputXml() {
        StringBuilder inputXMLWriter = new StringBuilder();
        inputXMLWriter.append("<?xml version=\"1.0\"?>").append(NEW_LINE);
        inputXMLWriter.append("<ISPF-INPUT>").append(NEW_LINE);
        inputXMLWriter.append("<SERVICE-REQUEST>").append(NEW_LINE);
        inputXMLWriter.append("<service>").append(this.serviceType).append("</service>").append(NEW_LINE);
        inputXMLWriter.append("<session>").append(this.session).append("</session>").append(NEW_LINE);
        inputXMLWriter.append("<command>").append(this.command).append("</command>").append(NEW_LINE);
        if (this.serviceType.equals(SERVICE_TYPE_ISPF) && this.ispProf != null) {
            inputXMLWriter.append("<ispprof>").append(this.ispProf).append("</ispprof>").append(NEW_LINE);
        }
        inputXMLWriter.append("</SERVICE-REQUEST>").append(NEW_LINE);
        inputXMLWriter.append("</ISPF-INPUT>").append(NEW_LINE);
        return inputXMLWriter.toString();
    }
}

