/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.ibm.jzos.FileFactory;
import com.ibm.jzos.ZFile;
import com.ibm.urbancode.zos.ispf.gateway.common.IspfGatewayExecutor;
import com.ibm.urbancode.zos.ispf.gateway.common.IspfGatewayXMLInput;
import com.ibm.urbancode.zos.ispf.gateway.common.IspfGatewayXMLResponse;
import com.urbancode.air.plugin.command.helpers.TempDatasetHelper;
import com.urbancode.air.plugin.command.helpers.TempIspfFileHelper;
import com.urbancode.air.plugin.command.inputs.PluginInputs;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;

public class RexxExecutor {
    private static final String PATH = "PATH";
    public static final String ISPF = "ISPF";
    public static final String TSO_EXEC = "TSO EXEC '";
    public static final String SINGLE_QUOTE = "'";
    private final Properties inputProperties;
    private final Properties outputProperties;
    private static final int ERROR_CODE = 8;

    public RexxExecutor(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() {
        int exitCode = 0;
        TempDatasetHelper tempDatasetHelper = null;
        try {
            PluginInputs pluginInputs = new PluginInputs(this.inputProperties);
            pluginInputs.validateInputs();
            tempDatasetHelper = new TempDatasetHelper(pluginInputs.getDsnPrefix(), pluginInputs.getSourceType(), pluginInputs.getSourceValue(), pluginInputs.getRexxArguments());
            tempDatasetHelper.setupDatasets();
            TempIspfFileHelper tempIspfFileHelper = new TempIspfFileHelper(tempDatasetHelper.getTempPDS(), pluginInputs.getSysprocDatasets(), pluginInputs.getDsnPrefix());
            tempIspfFileHelper.setUpIspf();
            String ispfPaths = tempIspfFileHelper.getTemporaryIspfDirectory() + File.pathSeparator + pluginInputs.getIspfGatewayPath();
            HashMap<String, String> environmentVariables = new HashMap<String, String>();
            environmentVariables.put(PATH, ispfPaths + File.pathSeparator + System.getenv(PATH));
            IspfGatewayXMLInput ispfGatewayXMLInput = new IspfGatewayXMLInput(ISPF, TSO_EXEC + tempDatasetHelper.getDriverProgramDataset() + SINGLE_QUOTE);
            IspfGatewayExecutor ispfGatewayExecutor = new IspfGatewayExecutor(pluginInputs.getIspfGatewayPath(), ispfGatewayXMLInput, pluginInputs.isDebugEnabled());
            ispfGatewayExecutor.setEnvironmentVars(environmentVariables);
            long startTime = System.currentTimeMillis();
            IspfGatewayXMLResponse ispfGatewayXMLResponse = ispfGatewayExecutor.execute();
            double seconds = (double)(System.currentTimeMillis() - startTime) / 1000.0;
            System.out.println(ispfGatewayXMLResponse.getOutputText());
            System.out.println("Elapsed time: " + seconds + " seconds.");
            this.outputProperties.put("RexxReturnCode", ispfGatewayXMLResponse.getReturnCode());
            if (Integer.parseInt(ispfGatewayXMLResponse.getReturnCode()) != 0) {
                int n = 8;
                return n;
            }
            this.setOutputPropertiesFromDataset(tempDatasetHelper.getOutputPropertiesDataset());
        }
        catch (RuntimeException runtimeException) {
            System.out.println(runtimeException.getMessage());
            exitCode = 8;
        }
        catch (Exception e) {
            e.printStackTrace();
            exitCode = 8;
        }
        finally {
            try {
                if (tempDatasetHelper != null) {
                    tempDatasetHelper.deleteTemporaryDatasets();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                exitCode = 8;
            }
        }
        return exitCode;
    }

    private void setOutputPropertiesFromDataset(String rexxOutputPropertiesDataset) throws IOException {
        try (BufferedReader factoryReader = FileFactory.newBufferedReader(ZFile.getSlashSlashQuotedDSN(rexxOutputPropertiesDataset, true));){
            this.outputProperties.load(factoryReader);
        }
    }
}

