/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos;

import com.ibm.jzos.ByteUtil;
import com.ibm.jzos.CatalogSearchField;
import com.ibm.jzos.RcException;
import com.ibm.jzos.ZUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class CatalogSearch
implements Iterator {
    public static final byte CATALOG_TYPE = 48;
    public static final byte FLAG_CSINTICF = -128;
    public static final byte FLAG_CSINOENT = 64;
    public static final byte FLAG_CSINTCMP = 32;
    public static final byte FLAG_CSICERR = 16;
    public static final byte FLAG_CSICERRP = 8;
    public static final byte FLAG_CSIPMENT = -128;
    public static final byte FLAG_CSIENTER = 64;
    public static final byte FLAG_CSIEDATA = 32;
    public static final int DEFAULT_WORK_AREA_LENGTH = 64000;
    public static final int MIN_WORK_AREA_LENGTH = 1024;
    public static final int MAX_WORK_AREA_LENGTH = 1048575;
    public static final int MAX_FIELD_NAMES = 100;
    private static final int CSIFILTK_OFFSET = 0;
    private static final int CSICATNM_OFFSET = 44;
    private static final int CSIRESNM_OFFSET = 88;
    private static final int CSIDTYPS_OFFSET = 132;
    private static final int CSICLDI_OFFSET = 148;
    private static final int CSIRESUME_OFFSET = 149;
    private static final int CSIS1CAT_OFFSET = 150;
    private static final int CSIOPTNS_OFFSET = 151;
    private static final int CSINUMENT_OFFSET = 152;
    private static final int CSIENTS_OFFSET = 154;
    private int lengthFieldLength = 2;
    private List fieldNames;
    private boolean searchActive = false;
    private byte[] selectionCriteria;
    private byte[] workArea;
    private int usedWorkAreaLength;
    private int workAreaOffset = 0;
    private String currentCatalogName;
    private CatalogSearchReasonArea reasonArea;

    public CatalogSearch(String filterKey) {
        this(filterKey, 64000);
    }

    public CatalogSearch(String filterKey, int workAreaLength) {
        this.initializeSelectionCriteria();
        this.workArea = new byte[workAreaLength];
        if (workAreaLength < 1024 || workAreaLength > 1048575) {
            throw new IllegalArgumentException("Work area must be between 1024 and 1048575 bytes.");
        }
        this.fieldNames = new ArrayList();
        this.setFilterKey(filterKey);
    }

    private void assertNotActive() {
        if (this.searchActive) {
            throw new IllegalStateException("Search already active. It may not be re-initiated.");
        }
    }

    private void assertActive() {
        if (!this.searchActive) {
            throw new IllegalStateException("Search is not active.  Initiate with a call to search()");
        }
    }

    private void criteriaChanged() {
        if (this.searchActive) {
            if (!this.isResume()) {
                throw new IllegalStateException("Selection criteria can only be modified on an active search if it is resumable.");
            }
            this.discardCurrentWorkArea();
        }
    }

    public void setFilterKey(String filterKey) {
        ByteUtil.putString(filterKey, this.selectionCriteria, 0, 44, "IBM-1047");
        this.criteriaChanged();
    }

    public String getFilterKey() {
        String s = ByteUtil.bytesAsString(this.selectionCriteria, 0, 44, "IBM-1047");
        return s.trim();
    }

    public void setCatalogName(String catalogName) {
        ByteUtil.putString(catalogName != null ? catalogName : "", this.selectionCriteria, 44, 44, "IBM-1047");
        this.criteriaChanged();
    }

    public String getCatalogName() {
        String s = ByteUtil.bytesAsString(this.selectionCriteria, 44, 44, "IBM-1047");
        return s.trim();
    }

    public void setResumeName(String resumeName) {
        this.assertActive();
        ByteUtil.putString(resumeName, this.selectionCriteria, 88, 44, "IBM-1047");
        this.criteriaChanged();
    }

    public String getResumeName() {
        this.assertActive();
        if (!this.isResume()) {
            throw new IllegalStateException("Catalog search is not resumable");
        }
        String s = ByteUtil.bytesAsString(this.selectionCriteria, 88, 44, "IBM-1047");
        return s.trim();
    }

    public void setEntryTypes(String entryTypes) {
        ByteUtil.putString(entryTypes != null ? entryTypes : "", this.selectionCriteria, 132, 16, "IBM-1047");
        this.criteriaChanged();
    }

    public String getEntryTypes() {
        String s = ByteUtil.bytesAsString(this.selectionCriteria, 132, 16, "IBM-1047");
        return s.trim();
    }

    public void setClusterNameMatch(boolean clusterNameMatch) {
        ByteUtil.putString(clusterNameMatch ? "Y" : " ", this.selectionCriteria, 148, 1, "IBM-1047");
        this.criteriaChanged();
    }

    public boolean isClusterNameMatch() {
        String s = ByteUtil.bytesAsString(this.selectionCriteria, 148, 1, "IBM-1047");
        return s.equalsIgnoreCase("Y");
    }

    public void setFullwordLengths(boolean fullwordLengths) {
        this.assertNotActive();
        this.lengthFieldLength = fullwordLengths ? 4 : 2;
        ByteUtil.putString(fullwordLengths ? "F" : " ", this.selectionCriteria, 151, 1, "IBM-1047");
    }

    public boolean isFullwordLengths() {
        return this.lengthFieldLength == 4;
    }

    public boolean isResume() {
        this.assertActive();
        String s = ByteUtil.bytesAsString(this.selectionCriteria, 149, 1, "IBM-1047");
        return s.equalsIgnoreCase("Y");
    }

    public void setSingleCatalog(boolean singleCatalog) {
        ByteUtil.putString(singleCatalog ? "Y" : " ", this.selectionCriteria, 150, 1, "IBM-1047");
        this.criteriaChanged();
    }

    public boolean isSingleCatalog() {
        String s = ByteUtil.bytesAsString(this.selectionCriteria, 150, 1, "IBM-1047");
        return s.equalsIgnoreCase("Y");
    }

    public void addFieldName(String fieldName) {
        if (this.fieldNames.size() > 100) {
            throw new IllegalArgumentException("A maximum of 100 field names is allowed.");
        }
        this.fieldNames.add(fieldName);
        this.criteriaChanged();
    }

    public void removeFieldName(String fieldName) {
        this.fieldNames.remove(fieldName);
        this.criteriaChanged();
    }

    public List getFieldNames() {
        return this.fieldNames;
    }

    public void search() {
        if (!this.searchActive) {
            this.searchActive = true;
            this.basicSearch();
        } else {
            this.discardCurrentWorkArea();
            if (this.isResume()) {
                this.basicSearch();
            }
        }
    }

    public int getRc() {
        this.assertActive();
        return this.reasonArea.rc;
    }

    public int getReason() {
        this.assertActive();
        return this.reasonArea.reason;
    }

    public String getModuleId() {
        this.assertActive();
        return this.reasonArea.moduleId;
    }

    public boolean hasNext() {
        this.assertActive();
        return this.workAreaHasNext() || this.isResume();
    }

    public Object next() {
        this.assertActive();
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Entry entry = null;
        if (this.workAreaOffset >= this.usedWorkAreaLength) {
            this.basicSearch();
        }
        entry = new Entry(this, this.workAreaOffset);
        this.workAreaOffset += entry.getEntryLength();
        if (entry.isCatalogEntry()) {
            this.currentCatalogName = entry.getName();
        }
        return entry;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public boolean workAreaHasNext() {
        this.assertActive();
        return this.workAreaOffset < this.usedWorkAreaLength;
    }

    public void discardCurrentWorkArea() {
        this.assertActive();
        this.workAreaOffset = this.usedWorkAreaLength;
    }

    private void basicSearch() {
        byte[] reasonBytes = new byte[4];
        ByteUtil.putInt(this.workArea.length, this.workArea, 0);
        this.prepareSelectionCriteria();
        int rc = this.callSearch(reasonBytes, this.selectionCriteria, this.workArea);
        int requiredWorkAreaLength = ByteUtil.bytesAsInt(this.workArea, 4, 4);
        if (requiredWorkAreaLength > this.workArea.length) {
            throw new RcException("Work area length " + this.workArea.length + " not large enough for search.  The minimum size needed is " + requiredWorkAreaLength + " bytes.", -1);
        }
        this.usedWorkAreaLength = ByteUtil.bytesAsInt(this.workArea, 8, 4);
        this.workAreaOffset = 14;
        this.reasonArea = new CatalogSearchReasonArea(reasonBytes, 0);
        if (rc != 0) {
            throw new RcException("Catalog search error", rc);
        }
    }

    private void initializeSelectionCriteria() {
        this.selectionCriteria = new byte[194];
        this.setCatalogName("");
        this.setEntryTypes("");
        this.setClusterNameMatch(false);
        this.setFullwordLengths(false);
        this.setSingleCatalog(false);
        ByteUtil.putString("", this.selectionCriteria, 88, 44, "IBM-1047");
        ByteUtil.putString(" ", this.selectionCriteria, 149, 1, "IBM-1047");
    }

    private void prepareSelectionCriteria() {
        int requiredLength = 154 + 8 * this.fieldNames.size();
        if (this.selectionCriteria.length < requiredLength) {
            byte[] newCriteria = new byte[requiredLength];
            System.arraycopy(this.selectionCriteria, 0, newCriteria, 0, 152);
            this.selectionCriteria = newCriteria;
        }
        ByteUtil.putLong(this.fieldNames.size(), this.selectionCriteria, 152, 2);
        int offset = 154;
        for (String fieldName : this.fieldNames) {
            offset += ByteUtil.putString(fieldName, this.selectionCriteria, offset, 8, "IBM-1047");
        }
    }

    private native int callSearch(byte[] var1, byte[] var2, byte[] var3);

    static {
        ZUtil.touch();
    }

    private static class CatalogSearchReasonArea {
        String moduleId = "";
        int rc = 0;
        int reason = 0;

        public CatalogSearchReasonArea(byte[] bytes, int offset) {
            this.moduleId = ByteUtil.bytesAsString(bytes, offset, 2, "IBM-1047");
            this.reason = ByteUtil.bytesAsInt(bytes, offset + 2, 1);
            this.rc = ByteUtil.bytesAsInt(bytes, offset + 3, 1);
        }
    }

    public static class Entry {
        private CatalogSearch catalogSearch;
        private byte[] bytes;
        private byte flag;
        private char type;
        private String name;
        private CatalogSearchReasonArea reasonArea;
        private int totalFieldDataLength = 0;
        private int fieldLengthsOffset;
        private int fieldDataOffset;
        private int[] fieldLengths;

        private Entry(CatalogSearch catalogSearch, int offset) {
            this.catalogSearch = catalogSearch;
            this.bytes = catalogSearch.workArea;
            this.flag = this.bytes[offset];
            this.type = ByteUtil.bytesAsString(this.bytes, offset + 1, 1, "IBM-1047").charAt(0);
            this.name = ByteUtil.bytesAsString(this.bytes, offset + 2, 44, "IBM-1047");
            if (this.hasReasonArea()) {
                this.reasonArea = new CatalogSearchReasonArea(this.bytes, offset + 46);
            } else {
                int lengthFieldLength = catalogSearch.lengthFieldLength;
                int numFields = catalogSearch.fieldNames.size();
                this.fieldLengths = new int[numFields];
                this.totalFieldDataLength = ByteUtil.bytesAsInt(this.bytes, offset + 46, lengthFieldLength);
                this.fieldLengthsOffset = offset + 46 + 2 * lengthFieldLength;
                this.fieldDataOffset = this.fieldLengthsOffset + numFields * lengthFieldLength;
                for (int i = 0; i < numFields; ++i) {
                    int fieldLength;
                    int flfOffset = this.fieldLengthsOffset + lengthFieldLength * i;
                    this.fieldLengths[i] = fieldLength = ByteUtil.bytesAsInt(this.bytes, flfOffset, lengthFieldLength);
                }
            }
            byte[] entryBytes = new byte[this.getEntryLength()];
            System.arraycopy(this.bytes, offset, entryBytes, 0, entryBytes.length);
            this.bytes = entryBytes;
            if (!this.hasReasonArea()) {
                this.fieldDataOffset -= offset;
                this.fieldLengthsOffset -= offset;
            }
        }

        public boolean isCatalogEntry() {
            return this.type == '0';
        }

        public boolean isDatasetEntry() {
            return !this.isCatalogEntry();
        }

        public boolean hasError() {
            return this.hasReasonArea() && this.getReasonArea().rc != 0;
        }

        public int getRc() {
            if (!this.hasReasonArea()) {
                return 0;
            }
            return this.getReasonArea().rc;
        }

        public int getReason() {
            if (!this.hasReasonArea()) {
                return 0;
            }
            return this.getReasonArea().reason;
        }

        public String getModuleId() {
            if (!this.hasReasonArea()) {
                return "";
            }
            return this.getReasonArea().moduleId;
        }

        public boolean hasReasonArea() {
            return this.isCatalogEntry() || (this.flag & 0x40) != 0;
        }

        public int getEntryLength() {
            if (this.hasReasonArea()) {
                return 50;
            }
            return this.totalFieldDataLength + 46;
        }

        public String getCatalogName() {
            return this.catalogSearch.currentCatalogName;
        }

        public byte getFlag() {
            return this.flag;
        }

        public char getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        private CatalogSearchReasonArea getReasonArea() {
            return this.reasonArea;
        }

        public CatalogSearchField getField(String fieldName) {
            if (this.isCatalogEntry()) {
                throw new UnsupportedOperationException("Catalog name entries do not have data fields");
            }
            int fieldNameIndex = this.catalogSearch.fieldNames.indexOf(fieldName);
            if (fieldNameIndex == -1) {
                throw new NoSuchElementException("Field named: " + fieldName + " does not exist in field data");
            }
            int fieldLength = this.fieldLengths[fieldNameIndex];
            int fieldOffset = 0;
            for (int i = 0; i < fieldNameIndex; ++i) {
                fieldOffset += this.fieldLengths[i] == -1 ? 0 : this.fieldLengths[i];
            }
            return new CatalogSearchField(fieldName, this.bytes, this.fieldDataOffset + fieldOffset, fieldLength, this.catalogSearch.lengthFieldLength);
        }
    }
}

