/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos;

import com.ibm.jzos.BufferCompressor;
import com.ibm.jzos.RcException;
import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ZCompressor
implements BufferCompressor {
    private long hCompress = 0L;

    public ZCompressor(int bits, byte[] dictionaries) {
        if (dictionaries == null) {
            throw new NullPointerException();
        }
        int dict_size = ZCompressor.getDictionaryLength(bits);
        if (dictionaries.length != dict_size * 2) {
            throw new IllegalArgumentException("Dictionaries must be " + dict_size * 2 + " bytes in length for symbols with " + bits + " bits");
        }
        this.hCompress = this.basicInit(dictionaries, bits);
    }

    public ZCompressor(int bits, InputStream dictionaryStream) throws IOException {
        this(bits, ZCompressor.readDictionaries(bits, dictionaryStream));
    }

    public ZCompressor(int bits, String dictionaryFilename) throws IOException {
        this(bits, ZCompressor.readDictionaries(bits, dictionaryFilename));
    }

    public static int getDictionaryLength(int symbolBits) {
        if (symbolBits < 9 || symbolBits > 13) {
            throw new IllegalArgumentException("symbolBits");
        }
        return 1 << symbolBits + 3;
    }

    public synchronized void release() {
        if (this.hCompress != 0L) {
            this.basicRelease(this.hCompress);
            this.hCompress = 0L;
        }
    }

    protected void finalize() throws Throwable {
        this.release();
        super.finalize();
    }

    public int compressBuffer(byte[] output, int outoff, byte[] input, int inoff, int inlen) throws RcException {
        Result result = this.compress(output, outoff, 0, input, inoff, inlen);
        int inRemaining = inlen - result.getSourceBytesUsed();
        if (inRemaining > 0) {
            return 0 - inRemaining;
        }
        if (result.getExtraCompressedBitsUsed() > 0) {
            return result.getTargetBytesUsed() + 1;
        }
        return result.getTargetBytesUsed();
    }

    public Result compress(byte[] output, int outoff, int outOffExtraBits, byte[] input, int inoff, int inlen) throws RcException {
        if (this.hCompress == 0L) {
            throw new IllegalStateException("released");
        }
        this.checkArgs(output, outoff, input, inoff, inlen);
        if (inlen == 0) {
            return new Result(outOffExtraBits);
        }
        long lengths = this.invokeCMPSC(this.hCompress, false, output, outoff, input, inoff, outOffExtraBits, inlen);
        return new Result(lengths);
    }

    public int expandBuffer(byte[] output, int outoff, byte[] input, int inoff, int inlen) throws RcException {
        Result result = this.expand(output, outoff, input, inoff, 0, inlen);
        int inRemaining = inlen - result.getSourceBytesUsed();
        if (inRemaining == 0 || inRemaining == 1 && result.getExtraCompressedBitsUsed() > 0) {
            return result.getTargetBytesUsed();
        }
        return 0 - inRemaining;
    }

    public Result expand(byte[] output, int outoff, byte[] input, int inoff, int inOffExtraBits, int inlen) throws RcException {
        if (this.hCompress == 0L) {
            throw new IllegalStateException("released");
        }
        this.checkArgs(output, outoff, input, inoff, inlen);
        if (inlen == 0) {
            return new Result(inOffExtraBits);
        }
        long lengths = this.invokeCMPSC(this.hCompress, true, output, outoff, input, inoff, inOffExtraBits, inlen);
        return new Result(lengths);
    }

    private void checkArgs(byte[] output, int outoff, byte[] input, int inoff, int inlen) {
        if (outoff < 0 || outoff >= output.length) {
            throw new IndexOutOfBoundsException("outoff=" + outoff + " output.length=" + output.length);
        }
        if (inoff < 0 || inlen < 0 || inoff >= input.length || inlen > input.length - inoff) {
            throw new IndexOutOfBoundsException("inlen=" + inlen + " input.length=" + input.length + " inoff=" + inoff);
        }
    }

    private static byte[] readDictionaries(int bits, String dictionaryFilename) throws IOException {
        InputStream is;
        if (dictionaryFilename.startsWith("//")) {
            dictionaryFilename = ZFile.getSlashSlashQuotedDSN(dictionaryFilename, true);
            ZFile zfile = new ZFile(dictionaryFilename, "rb");
            is = zfile.getInputStream();
        } else {
            is = new FileInputStream(dictionaryFilename);
        }
        return ZCompressor.readDictionaries(bits, is);
    }

    private static byte[] readDictionaries(int bits, InputStream is) throws IOException {
        int dictsLen = ZCompressor.getDictionaryLength(bits) * 2;
        byte[] dicts = new byte[dictsLen];
        int nRead = is.read(dicts);
        if (nRead < dictsLen || is.read() != -1) {
            throw new IOException("Dictionaries must be " + dictsLen + " bytes in length for symbols with " + bits + " bits");
        }
        return dicts;
    }

    private native long basicInit(byte[] var1, int var2);

    private native void basicRelease(long var1);

    private native long invokeCMPSC(long var1, boolean var3, byte[] var4, int var5, byte[] var6, int var7, int var8, int var9);

    static {
        ZUtil.touch();
    }

    public static class Result {
        private int sourceBytesUsed;
        private int targetBytesUsed;
        private int extraCompressedBitsUsed;

        Result(long lengths) {
            this.targetBytesUsed = (int)(lengths >>> 32);
            this.sourceBytesUsed = (int)(lengths & 0xFFFFFFFFFFFFFFFFL) >>> 8;
            this.extraCompressedBitsUsed = (int)(lengths & 0xFFL);
        }

        public int getSourceBytesUsed() {
            return this.sourceBytesUsed;
        }

        public int getTargetBytesUsed() {
            return this.targetBytesUsed;
        }

        public int getExtraCompressedBitsUsed() {
            return this.extraCompressedBitsUsed;
        }
    }
}

