/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.helpers;

import com.ibm.jzos.RecordWriter;
import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZFileException;
import com.ibm.jzos.ZUtil;
import com.urbancode.air.plugin.command.helpers.RexxCodeSnippets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TempDatasetHelper {
    public static final String SETPROP = "SETPROP";
    public static final String GETDLMTR = "GETDLMTR";
    public static final String INPUT = "INPUT";
    private static final int LRECL = 260;
    private static final String DRIVER = "BUZDRVR";
    private static final String SOURCE_TYPE_INLINE = "INLINE";
    private static final int BLK_SIZE = 28084;
    private static final String TIMESTAMP_FORMAT = "HHmmss.SSS";
    private static final String MID_QUALIFIER = ".BUZREXX.R";
    private static final String PROP_LLQ = ".PROP";
    private final String sourceType;
    private final String sourceValue;
    private final String rexxArguments;
    private final String tempPDS;
    private final String outputPropertiesDataset;

    public TempDatasetHelper(String dsnPrefix, String sourceType, String sourceValue, String rexxArguments) throws NoSuchAlgorithmException {
        this.sourceType = sourceType;
        this.sourceValue = sourceValue;
        this.rexxArguments = rexxArguments;
        String uniqueDatasetQualifiers = this.generateUniqueDatasetQualifiers();
        this.tempPDS = dsnPrefix + uniqueDatasetQualifiers;
        this.outputPropertiesDataset = dsnPrefix + uniqueDatasetQualifiers + PROP_LLQ;
    }

    public void setupDatasets() throws IOException {
        this.createTemporaryDatasets();
        this.populateRexxCodeSnippets();
    }

    public void deleteTemporaryDatasets() throws ZFileException {
        this.deleteDataset(this.tempPDS);
        this.deleteDataset(this.outputPropertiesDataset);
    }

    private void createTemporaryDatasets() {
        this.createEmptyPDSForHelperPrograms();
        this.createDatasetToStoreOutputProperties();
    }

    private void populateRexxCodeSnippets() throws IOException {
        this.copyCodeToPDSMember(SETPROP, RexxCodeSnippets.getSetPropertyProgram(this.outputPropertiesDataset));
        this.copyCodeToPDSMember(GETDLMTR, RexxCodeSnippets.getDelimiterProgram());
        if (this.sourceType.equals(SOURCE_TYPE_INLINE)) {
            this.copyCodeToPDSMember(INPUT, this.sourceValue);
        }
        String singleQuotedRexxDataset = this.getSingleQuotedRexxDataset();
        this.copyCodeToPDSMember(DRIVER, RexxCodeSnippets.getDriverRexxProgram(singleQuotedRexxDataset, this.rexxArguments));
    }

    private String getSingleQuotedRexxDataset() {
        if (this.sourceType.equals(SOURCE_TYPE_INLINE)) {
            return "'" + this.tempPDS + "(" + INPUT + ")'";
        }
        return this.sourceValue;
    }

    private String generateUniqueDatasetQualifiers() throws NoSuchAlgorithmException {
        SecureRandom secureRandom = SecureRandom.getInstanceStrong();
        String randomizedDsnPrefix = MID_QUALIFIER + secureRandom.nextInt(1000000);
        String formattedDate = new SimpleDateFormat(TIMESTAMP_FORMAT).format(new Date());
        return randomizedDsnPrefix + ".T" + formattedDate.substring(0, 6) + ".M" + formattedDate.substring(7, 10);
    }

    private void createEmptyPDSForHelperPrograms() {
        String ddName = ZFile.allocDummyDDName();
        String allocateCommand = "alloc fi(" + ddName + ") da(" + this.tempPDS + ") reuse new catalog msg(wtp) recfm(v,b) space(5,5) cyl dir(1) lrecl(" + 260 + ") blksize(" + 28084 + ")";
        ZFile.bpxwdyn(allocateCommand);
        ZFile.bpxwdyn("free fi(" + ddName + ") msg(wtp)");
    }

    private void createDatasetToStoreOutputProperties() {
        String ddName = ZFile.allocDummyDDName();
        String createDatasetCmd = "alloc fi(" + ddName + ") da(" + this.outputPropertiesDataset + ") reuse new catalog msg(wtp) recfm(f,b) space(5,5) cyl lrecl(" + 1000 + ") blksize(" + 27000 + ")";
        ZFile.bpxwdyn(createDatasetCmd);
        ZFile.bpxwdyn("free fi(" + ddName + ") msg(wtp)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyCodeToPDSMember(String memberName, String rexxStatements) throws IOException {
        RecordWriter writer = RecordWriter.newWriter(ZFile.getSlashSlashQuotedDSN(this.tempPDS + "(" + memberName + ")", true), 4);
        try (BufferedReader br = new BufferedReader(new StringReader(rexxStatements));){
            String line;
            while ((line = br.readLine()) != null) {
                byte[] bytes = line.getBytes(ZUtil.getDefaultPlatformEncoding());
                writer.write(bytes, 0, bytes.length);
            }
        }
        finally {
            writer.close();
            writer.flush();
        }
    }

    public String getOutputPropertiesDataset() {
        return this.outputPropertiesDataset;
    }

    public String getDriverProgramDataset() {
        return this.getTempPDS() + "(" + DRIVER + ")";
    }

    public String getTempPDS() {
        return this.tempPDS;
    }

    private void deleteDataset(String dataset) throws ZFileException {
        if (ZFile.exists(ZFile.getSlashSlashQuotedDSN(dataset, true))) {
            ZFile.remove(ZFile.getSlashSlashQuotedDSN(dataset, true));
        }
    }
}

