/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.wlm;

import com.ibm.jzos.ErrnoException;
import com.ibm.jzos.JzosPermission;
import com.ibm.jzos.ZUtil;
import com.ibm.jzos.wlm.ServerClassification;
import java.util.HashSet;
import java.util.Iterator;

public class WorkloadManager {
    private int connToken;
    private HashSet<ServerClassification> serverClassifications = new HashSet();

    public WorkloadManager(String subSystemType, String subSystemName) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new JzosPermission("WorkloadManager"));
        }
        this.connToken = this.connectWorkManager(subSystemType, subSystemName);
    }

    public synchronized void disconnect() throws ErrnoException {
        Iterator<ServerClassification> iter = this.serverClassifications.iterator();
        while (iter.hasNext()) {
            ServerClassification sc = iter.next();
            try {
                sc.destroy();
            }
            catch (ErrnoException ee) {
                ee.printStackTrace();
            }
            iter.remove();
        }
        if (this.connToken != 0) {
            this.disconnectServer(this.connToken);
            this.connToken = 0;
        }
    }

    public synchronized ServerClassification createServerClassification() throws ErrnoException {
        if (this.connToken == 0) {
            throw new IllegalStateException("WorkloadManager is not connected");
        }
        ServerClassification sc = new ServerClassification(this.connToken);
        this.serverClassifications.add(sc);
        return sc;
    }

    public synchronized void destroyServerClassification(ServerClassification sc) throws ErrnoException {
        if (sc == null) {
            throw new NullPointerException();
        }
        if (!this.serverClassifications.remove(sc)) {
            throw new IllegalStateException("ServerClassification is not associated with this WorkloadManager");
        }
        sc.destroy();
    }

    public int getConnToken() {
        if (this.connToken == 0) {
            throw new IllegalStateException("WorkloadManager is not connected");
        }
        return this.connToken;
    }

    private native int connectWorkManager(String var1, String var2) throws ErrnoException;

    private native void disconnectServer(int var1) throws ErrnoException;

    static {
        ZUtil.touch();
    }
}

