/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.fields;

import com.ibm.jzos.fields.IntAccessor;

public class BinaryAsIntField
implements IntAccessor {
    public static final int MAX_FIELD_WIDTH = 4;
    public static final int DEFAULT_FIELD_WIDTH = 4;
    public static final int SIGNED_MIN_LEN1_VAL = -128;
    public static final int SIGNED_MAX_LEN1_VAL = 127;
    public static final int SIGNED_MIN_LEN2_VAL = Short.MIN_VALUE;
    public static final int SIGNED_MAX_LEN2_VAL = Short.MAX_VALUE;
    public static final int SIGNED_MIN_LEN3_VAL = -8388608;
    public static final int SIGNED_MAX_LEN3_VAL = 0x7FFFFF;
    public static final int SIGNED_MIN_LEN4_VAL = Integer.MIN_VALUE;
    public static final int SIGNED_MAX_LEN4_VAL = Integer.MAX_VALUE;
    public static final int UNSIGNED_MAX_LEN1_VAL = 255;
    public static final int UNSIGNED_MAX_LEN2_VAL = 65535;
    public static final int UNSIGNED_MAX_LEN3_VAL = 0xFFFFFF;
    public static final int UNSIGNED_MAX_LEN4_VAL = Integer.MAX_VALUE;
    private int offset;
    private int length;
    private boolean signed;

    public BinaryAsIntField(int offset) {
        this(offset, 4, true);
    }

    public BinaryAsIntField(int offset, int length) {
        this(offset, length, true);
    }

    public BinaryAsIntField(int offset, int length, boolean signed) {
        if (length > 4 || length <= 0) {
            throw new IllegalArgumentException("length");
        }
        this.offset = offset;
        this.length = length;
        this.signed = signed;
    }

    public int getByteLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getInt(byte[] buffer) {
        return this.getInt(buffer, 0);
    }

    public int getInt(byte[] buffer, int bufOffset) {
        int answer;
        int i = this.offset + bufOffset;
        switch (this.length) {
            case 1: {
                if (this.signed) {
                    answer = buffer[i];
                    break;
                }
                answer = buffer[i] & 0xFF;
                break;
            }
            case 2: {
                answer = ((buffer[i] & 0xFF) << 8) + (buffer[i + 1] & 0xFF);
                if (!this.signed) break;
                answer = (short)answer;
                break;
            }
            case 3: {
                if (this.signed) {
                    short s = (short)(((buffer[i] & 0xFF) << 8) + (buffer[i + 1] & 0xFF));
                    answer = (s << 8) + (buffer[i + 2] & 0xFF);
                    break;
                }
                answer = ((buffer[i] & 0xFF) << 16) + ((buffer[i + 1] & 0xFF) << 8) + (buffer[i + 2] & 0xFF);
                break;
            }
            default: {
                answer = ((buffer[i] & 0xFF) << 24) + ((buffer[i + 1] & 0xFF) << 16) + ((buffer[i + 2] & 0xFF) << 8) + (buffer[i + 3] & 0xFF);
                if (this.signed || answer >= 0) break;
                throw new IllegalArgumentException("negative value in unsigned field");
            }
        }
        return answer;
    }

    public void putInt(int value, byte[] buffer) throws IllegalArgumentException {
        this.putInt(value, buffer, 0);
    }

    public void putInt(int value, byte[] buffer, int bufOffset) throws IllegalArgumentException {
        int i = this.offset + bufOffset;
        switch (this.length) {
            case 1: {
                if (this.signed) {
                    this.rangeCheck(value, -128, 127);
                } else {
                    this.rangeCheck(value, 0, 255);
                }
                buffer[i] = (byte)value;
                break;
            }
            case 2: {
                if (this.signed) {
                    this.rangeCheck(value, Short.MIN_VALUE, Short.MAX_VALUE);
                } else {
                    this.rangeCheck(value, 0, 65535);
                }
                buffer[i] = (byte)(value >> 8);
                buffer[i + 1] = (byte)value;
                break;
            }
            case 3: {
                if (this.signed) {
                    this.rangeCheck(value, -8388608, 0x7FFFFF);
                } else {
                    this.rangeCheck(value, 0, 0xFFFFFF);
                }
                buffer[i] = (byte)(value >> 16);
                buffer[i + 1] = (byte)(value >> 8);
                buffer[i + 2] = (byte)value;
                break;
            }
            default: {
                if (this.signed) {
                    this.rangeCheck(value, Integer.MIN_VALUE, Integer.MAX_VALUE);
                } else {
                    this.rangeCheck(value, 0, Integer.MAX_VALUE);
                }
                buffer[i] = (byte)(value >> 24);
                buffer[i + 1] = (byte)(value >> 16);
                buffer[i + 2] = (byte)(value >> 8);
                buffer[i + 3] = (byte)value;
            }
        }
    }

    private void rangeCheck(int val, int min, int max) throws IllegalArgumentException {
        if (val < min || val > max) {
            throw new IllegalArgumentException("" + val);
        }
    }

    public boolean isSigned() {
        return this.signed;
    }

    public void setSigned(boolean signed) {
        this.signed = signed;
    }

    public boolean equals(Integer anInteger, int anInt) {
        if (anInteger == null) {
            return false;
        }
        return anInteger == anInt;
    }
}

