/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.fields;

import com.ibm.jzos.fields.BinaryAsIntField;
import com.ibm.jzos.fields.BinaryAsLongField;
import com.ibm.jzos.fields.DatatypeFactory;
import com.ibm.jzos.fields.Field;
import com.ibm.jzos.fields.IbmDoubleField;
import com.ibm.jzos.fields.IbmFloatField;
import com.ibm.jzos.fields.PackedDecimalAsBigDecimalField;
import com.ibm.jzos.fields.PackedDecimalAsBigIntegerField;
import com.ibm.jzos.fields.PackedDecimalAsIntField;
import com.ibm.jzos.fields.PackedDecimalAsLongField;

public class AssemblerDatatypeFactory
extends DatatypeFactory {
    public BinaryAsLongField getBinaryAsLongField(int length, boolean signed) {
        BinaryAsLongField field = new BinaryAsLongField(this.offset, length, signed);
        this.advanceOffset(field);
        return field;
    }

    public BinaryAsIntField getBinaryAsIntField(int length, boolean signed) {
        BinaryAsIntField field = new BinaryAsIntField(this.offset, length, signed);
        this.advanceOffset(field);
        return field;
    }

    public Field getBinaryField(int length, boolean signed) {
        if (length < 4 || length == 4 && signed) {
            return this.getBinaryAsIntField(length, signed);
        }
        if (length <= 8) {
            return this.getBinaryAsLongField(length, signed);
        }
        throw new IllegalArgumentException("length");
    }

    public Field getPackedDecimalField(int length, int scale, boolean signed) {
        int precision = length * 2 - 1;
        if (scale > 0) {
            return this.getPackedDecimalAsBigDecimalField(length, scale, signed);
        }
        if (scale < 0) {
            return this.getPackedDecimalAsBigIntegerField(length, scale, signed);
        }
        if (precision <= 9) {
            return this.getPackedDecimalAsIntField(length, signed);
        }
        if (precision <= 18) {
            return this.getPackedDecimalAsLongField(length, signed);
        }
        if (precision <= 31) {
            return this.getPackedDecimalAsBigIntegerField(length, scale, signed);
        }
        throw new IllegalArgumentException("precision too big");
    }

    public PackedDecimalAsBigDecimalField getPackedDecimalAsBigDecimalField(int length, int scale, boolean signed) {
        int precision = length * 2 - 1;
        PackedDecimalAsBigDecimalField field = new PackedDecimalAsBigDecimalField(this.offset, precision, scale, signed);
        this.advanceOffset(field);
        return field;
    }

    public PackedDecimalAsBigIntegerField getPackedDecimalAsBigIntegerField(int length, int scale, boolean signed) {
        int precision = length * 2 - 1;
        PackedDecimalAsBigIntegerField field = new PackedDecimalAsBigIntegerField(this.offset, precision, scale, signed);
        this.advanceOffset(field);
        return field;
    }

    public PackedDecimalAsIntField getPackedDecimalAsIntField(int length, boolean signed) {
        int precision = length * 2 - 1;
        PackedDecimalAsIntField field = new PackedDecimalAsIntField(this.offset, precision, signed);
        this.advanceOffset(field);
        return field;
    }

    public PackedDecimalAsLongField getPackedDecimalAsLongField(int length, boolean signed) {
        int precision = length * 2 - 1;
        PackedDecimalAsLongField field = new PackedDecimalAsLongField(this.offset, precision, signed);
        this.advanceOffset(field);
        return field;
    }

    public Field getZonedDecimalField(int length, int scale, boolean signed) {
        boolean signExternal = false;
        boolean signTailing = true;
        boolean blankWhenZero = false;
        int precision = length;
        if (scale > 0) {
            return this.getExternalDecimalAsBigDecimalField(precision, scale, signed, signTailing, signExternal, blankWhenZero);
        }
        if (scale < 0) {
            return this.getExternalDecimalAsBigIntegerField(precision, scale, signed, signTailing, signExternal, blankWhenZero);
        }
        if (precision <= 9) {
            return this.getExternalDecimalAsIntField(precision, signed, signTailing, signExternal, blankWhenZero);
        }
        if (precision <= 18) {
            return this.getExternalDecimalAsLongField(precision, signed, signTailing, signExternal, blankWhenZero);
        }
        if (precision <= 31) {
            return this.getExternalDecimalAsBigIntegerField(precision, scale, signed, signTailing, signExternal, blankWhenZero);
        }
        throw new IllegalArgumentException("precision too big");
    }

    public IbmFloatField getIbmFloatField() {
        IbmFloatField field = new IbmFloatField(this.offset);
        this.advanceOffset(field);
        return field;
    }

    public IbmDoubleField getIbmDoubleField() {
        IbmDoubleField field = new IbmDoubleField(this.offset);
        this.advanceOffset(field);
        return field;
    }
}

