/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos;

import com.ibm.jzos.Bsam;
import com.ibm.jzos.BsamRecordWriter;
import com.ibm.jzos.ZFileException;

class BsamVRecordWriter
extends BsamRecordWriter {
    public static final int BDW_LEN = 4;
    public static final int RDW_LEN = 4;
    protected int lrecl;
    protected byte[] block;
    protected int blockOffset;

    BsamVRecordWriter(Bsam bsam) throws ZFileException {
        super(bsam);
        this.lrecl = bsam.getLrecl();
        this.block = new byte[bsam.getBlksize()];
        this.blockOffset = 4;
    }

    public synchronized void write(byte[] buf, int offset, int len) throws ZFileException {
        this.writeRecord(buf, offset, len);
        this.writeBlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeBlock() throws ZFileException {
        if (this.blockOffset <= 32760) {
            this.block[0] = (byte)(this.blockOffset >>> 8 & 0xFF);
            this.block[1] = (byte)(this.blockOffset & 0xFF);
            this.block[2] = 0;
            this.block[3] = 0;
        } else {
            this.block[0] = (byte)(this.blockOffset >>> 24 & 0xFF | 0x80);
            this.block[1] = (byte)(this.blockOffset >>> 16 & 0xFF);
            this.block[2] = (byte)(this.blockOffset >>> 8 & 0xFF);
            this.block[3] = (byte)(this.blockOffset & 0xFF);
        }
        try {
            this.bsam.writeBlock(this.block, 0, this.blockOffset);
        }
        finally {
            this.blockOffset = 4;
        }
    }

    protected void writeRecord(byte[] buf, int offset, int len) {
        this.putRDW(len, this.block, this.blockOffset);
        this.blockOffset += 4;
        System.arraycopy(buf, offset, this.block, this.blockOffset, len);
        this.blockOffset += len;
    }

    private void putRDW(int length, byte[] bytes, int offset) {
        if ((length += 4) > this.lrecl) {
            throw new IllegalArgumentException("Record length " + (length - 4) + " is too big for LRECL " + this.lrecl);
        }
        bytes[offset] = (byte)(length >>> 8 & 0xFF);
        bytes[offset + 1] = (byte)(length & 0xFF);
        bytes[offset + 2] = 0;
        bytes[offset + 3] = 0;
    }
}

