/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos;

import com.ibm.jzos.Bsam;
import com.ibm.jzos.BsamFbRecordWriter;
import com.ibm.jzos.BsamVRecordWriter;
import com.ibm.jzos.BsamVbRecordWriter;
import com.ibm.jzos.BsamVbsRecordWriter;
import com.ibm.jzos.Messages;
import com.ibm.jzos.RecordWriter;
import com.ibm.jzos.ZFileException;

class BsamRecordWriter
extends RecordWriter {
    protected Bsam bsam;

    protected BsamRecordWriter(Bsam bsam) {
        this.bsam = bsam;
    }

    public static synchronized BsamRecordWriter newWriterForDD(String ddname) throws ZFileException {
        int openFlag = 64;
        Bsam bsam = new Bsam(ddname, openFlag);
        BsamRecordWriter writer = null;
        if ((bsam.getRecfmBits() & 4) == 4) {
            writer = new BsamRecordWriter(bsam);
        } else if ((bsam.getRecfmBits() & 1) == 1) {
            writer = (bsam.getRecfmBits() & 8) == 0 ? new BsamRecordWriter(bsam) : new BsamFbRecordWriter(bsam);
        } else if ((bsam.getRecfmBits() & 2) == 2) {
            writer = (bsam.getRecfmBits() & 0x10) == 16 ? new BsamVbsRecordWriter(bsam) : ((bsam.getRecfmBits() & 8) == 8 ? new BsamVbRecordWriter(bsam) : new BsamVRecordWriter(bsam));
        } else {
            throw new IllegalArgumentException(Messages.getString("RecordReader.RecfmNotSupported"));
        }
        return writer;
    }

    public synchronized void write(byte[] buf) throws ZFileException {
        this.write(buf, 0, buf.length);
    }

    public synchronized void write(byte[] buf, int offset, int len) throws ZFileException {
        if ((this.bsam.getRecfmBits() & 1) == 1 && len != this.getBlksize()) {
            throw new IllegalArgumentException("write length " + len + " does not match blocksize of " + this.getBlksize());
        }
        this.bsam.writeBlock(buf, offset, len);
    }

    public synchronized void close() throws ZFileException {
        this.bsam.close();
        this.doAutoFree();
    }

    public synchronized void flush() throws ZFileException {
        this.bsam.flush();
    }

    public synchronized int getLrecl() {
        return this.bsam.getLrecl();
    }

    public synchronized int getBlksize() {
        return this.bsam.getBlksize();
    }

    public synchronized int getRecfmBits() {
        return this.bsam.getRecfmBits();
    }

    public synchronized String getRecfm() {
        return this.bsam.getRecfm();
    }

    public synchronized String getDDName() {
        return this.bsam.getDDName();
    }

    public synchronized String getDsn() {
        return this.bsam.getDsn();
    }

    public synchronized String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("(");
        if (this.bsam != null) {
            sb.append("ddname=" + this.getDDName());
            sb.append(",dsn=" + this.getDsn());
        }
        sb.append(")");
        return sb.toString();
    }
}

