/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos;

import com.ibm.jzos.Bsam;
import com.ibm.jzos.BsamRecordWriter;
import com.ibm.jzos.ZFileException;

class BsamFbRecordWriter
extends BsamRecordWriter {
    private int lrecl;
    private byte[] block;
    private int currentOffset;

    BsamFbRecordWriter(Bsam bsam) throws ZFileException {
        super(bsam);
        this.lrecl = bsam.getLrecl();
        this.block = new byte[bsam.getBlksize()];
        this.currentOffset = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void write(byte[] buf, int offset, int len) throws ZFileException {
        if (len != this.lrecl) {
            throw new IllegalArgumentException("Record length " + len + " Doesn't match fixed LRECL of " + this.lrecl);
        }
        if (this.currentOffset == this.block.length) {
            try {
                this.bsam.writeBlock(this.block);
            }
            finally {
                this.currentOffset = 0;
            }
        }
        System.arraycopy(buf, offset, this.block, this.currentOffset, len);
        this.currentOffset += len;
    }

    public synchronized void close() throws ZFileException {
        if (this.currentOffset != 0) {
            this.bsam.writeBlock(this.block, 0, this.currentOffset);
        }
        super.close();
    }
}

