/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.helpers;

import com.urbancode.air.plugin.command.helpers.RexxCodeSnippets;
import com.urbancode.air.plugin.command.utils.FileException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;

public class TempIspfFileHelper {
    private static final String SYSPROC = "sysproc";
    private static final String TEMP_DIRECTORY_PREFIX = "tmp_rexx_plugin_";
    private String tempIspfGatewayDirectory;
    private final String tempDataset;
    private final String userSysprocDatasets;
    private final String dsnPrefix;
    private static final String AGENT_ISPF_CONF_FILE = System.getenv("AGENT_HOME") + "/conf/toolkit/ISPF.conf";
    private static final String ISPF_CONF_FILE = "ISPF.conf";
    private static final String ISPZXENV = "ISPZXENV";

    public TempIspfFileHelper(String tempDataset, String userSysprocDatasets, String dsnPrefix) {
        this.tempDataset = tempDataset;
        this.userSysprocDatasets = userSysprocDatasets;
        this.dsnPrefix = dsnPrefix;
    }

    public void setUpIspf() throws IOException {
        this.tempIspfGatewayDirectory = this.createDirectoryToStoreIspfFiles();
        File ispzxenvFile = this.createFile(ISPZXENV);
        File ispfConfFile = this.createFile(ISPF_CONF_FILE);
        this.setExecutableOnIspzxenvFile(ispzxenvFile);
        this.populateIspfConfFile(ispfConfFile);
        this.populateIspzxenvFile(ispzxenvFile);
    }

    private String createDirectoryToStoreIspfFiles() throws IOException {
        String currentWorkingDirPath = new File(".").getCanonicalPath();
        File tempDirectory = Files.createTempDirectory(Paths.get(currentWorkingDirPath, new String[0]), TEMP_DIRECTORY_PREFIX, new FileAttribute[0]).toFile();
        tempDirectory.deleteOnExit();
        return tempDirectory.getCanonicalPath();
    }

    private void setExecutableOnIspzxenvFile(File ispzxenvFile) {
        if (!ispzxenvFile.setExecutable(true, false)) {
            throw new FileException("Unable to set executable permissions for ISPZXENV file.");
        }
    }

    private File createFile(String fileName) throws IOException {
        File file = new File(this.tempIspfGatewayDirectory + File.separator + fileName);
        if (!file.createNewFile()) {
            throw new FileException("Unable to create " + file.getCanonicalPath() + " file");
        }
        file.deleteOnExit();
        return file;
    }

    private void populateIspzxenvFile(File ispzxenvFile) throws IOException {
        String ispzxenvRexx = RexxCodeSnippets.getCustomIspzxenvRexx(this.tempIspfGatewayDirectory, this.dsnPrefix);
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(ispzxenvFile));){
            bw.write(ispzxenvRexx);
            bw.flush();
        }
    }

    private void populateIspfConfFile(File ispfConfFile) throws IOException {
        Properties ispfConfProperties = TempIspfFileHelper.getAgentIspfConfFileProperties();
        String updatedSysproc = this.getUpdatedSysproc(ispfConfProperties.getProperty(SYSPROC));
        ispfConfProperties.put(SYSPROC, updatedSysproc);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(ispfConfFile));){
            ispfConfProperties.store(writer, "Dynamic ISPF file for this plugin execution");
            writer.flush();
        }
    }

    private String getUpdatedSysproc(String agentIspfConfSysproc) {
        String updatedSysproc = agentIspfConfSysproc.isEmpty() ? this.tempDataset : this.tempDataset + "," + agentIspfConfSysproc;
        if (!this.userSysprocDatasets.isEmpty()) {
            updatedSysproc = updatedSysproc + "," + this.userSysprocDatasets;
        }
        return updatedSysproc;
    }

    private static Properties getAgentIspfConfFileProperties() throws IOException {
        File agentIspfConfFile = new File(AGENT_ISPF_CONF_FILE);
        Properties ispfConfProperties = new Properties();
        try (BufferedReader reader = new BufferedReader(new FileReader(agentIspfConfFile));){
            ispfConfProperties.load(reader);
        }
        return ispfConfProperties;
    }

    public String getTemporaryIspfDirectory() {
        return this.tempIspfGatewayDirectory;
    }
}

