/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.ispf.gateway.common;

import com.ibm.urbancode.zos.ispf.gateway.common.ServiceType;
import com.ibm.urbancode.zos.ispf.gateway.common.Session;

public class IspfGatewayXMLInput {
    private static final String NEW_LINE = System.lineSeparator();
    private static final Session DEFAULT_SESSION = Session.NONE;
    private final ServiceType serviceType;
    private final String command;
    private Session session = DEFAULT_SESSION;
    private String ispProf = null;

    public IspfGatewayXMLInput(ServiceType serviceType, String command) {
        this.serviceType = serviceType;
        this.command = command;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public void setIspProf(String ispProf) {
        this.ispProf = ispProf;
    }

    public String getIspfInputXml() {
        StringBuilder inputXMLWriter = new StringBuilder();
        inputXMLWriter.append("<?xml version=\"1.0\"?>").append(NEW_LINE);
        inputXMLWriter.append("<ISPF-INPUT>").append(NEW_LINE);
        inputXMLWriter.append("<SERVICE-REQUEST>").append(NEW_LINE);
        inputXMLWriter.append("<service>").append(this.serviceType.toString()).append("</service>").append(NEW_LINE);
        inputXMLWriter.append("<session>").append(this.session.toString()).append("</session>").append(NEW_LINE);
        inputXMLWriter.append("<command>").append(this.command).append("</command>").append(NEW_LINE);
        if (this.isServiceTypeIspf() && this.ispProf != null) {
            inputXMLWriter.append("<ispprof>").append(this.ispProf).append("</ispprof>").append(NEW_LINE);
        }
        inputXMLWriter.append("</SERVICE-REQUEST>").append(NEW_LINE);
        inputXMLWriter.append("</ISPF-INPUT>").append(NEW_LINE);
        return inputXMLWriter.toString();
    }

    private boolean isServiceTypeIspf() {
        return this.serviceType == ServiceType.ISPF;
    }
}

