/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos;

import com.ibm.jzos.ByteUtil;
import com.ibm.jzos.Messages;
import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZFileException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Date;
import java.util.NoSuchElementException;

public class PdsDirectory {
    private ZFile directory;
    private Iterator iterator;

    public PdsDirectory(String pdsName) throws IOException {
        this.directory = new ZFile(pdsName, "rb,recfm=u,type=record,blksize=256");
        if ((this.directory.getDsorg() & 5) != 5) {
            this.directory.close();
            this.directory = null;
            throw new ZFileException(pdsName, Messages.getString("PdsDirectory.TheName") + pdsName + Messages.getString("PdsDirectory.NotAPdsDirectory"), -1);
        }
    }

    public void close() throws IOException {
        this.directory.close();
    }

    public java.util.Iterator iterator() {
        if (this.iterator == null) {
            this.iterator = new Iterator();
        }
        return this.iterator;
    }

    class Iterator
    implements java.util.Iterator {
        private byte[] cb = new byte[256];
        int pos;
        private int blen;

        public Iterator() {
            this.getNextBlock();
        }

        private void getNextBlock() {
            try {
                if (PdsDirectory.this.directory.read(this.cb) == 0) {
                    throw new IllegalStateException(Messages.getString("PdsDirectory.DirectoryBlockNotFound"));
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(Messages.getString("PdsDirectory.IOExceptionReadingDirectoryBlock") + ioe.getMessage());
            }
            this.blen = ByteUtil.bytesAsInt(this.cb, 0, 2);
            this.pos = 2;
        }

        public boolean hasNext() {
            if (this.pos + 1 >= this.blen) {
                this.getNextBlock();
            }
            for (int i = this.pos; i < this.pos + 8; ++i) {
                if (this.cb[i] == -1) continue;
                return true;
            }
            return false;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            MemberInfo mi = new MemberInfo(this.cb, this.pos);
            this.pos += mi.getSizeInBytes();
            return mi;
        }

        MemberInfo find(String memberName) {
            byte[] mnToFind;
            if ((memberName = memberName.toUpperCase()).length() > 8) {
                throw new IllegalArgumentException("member name is greater than 8 bytes");
            }
            if (memberName.length() < 8) {
                memberName = (memberName + "        ").substring(0, 8);
            }
            try {
                mnToFind = memberName.getBytes("IBM-1047");
            }
            catch (UnsupportedEncodingException ee) {
                throw new RuntimeException(ee);
            }
            while (this.hasNext()) {
                int a = 0;
                int b = 0;
                for (int i = 0; i < 8 && (a = mnToFind[i] & 0xFF) == (b = this.cb[this.pos + i] & 0xFF); ++i) {
                }
                if (a == b) {
                    return new MemberInfo(this.cb, this.pos);
                }
                if (a < b) {
                    return null;
                }
                int memberLen = (this.cb[this.pos + 11] & 0x1F) * 2 + 12;
                this.pos += memberLen;
            }
            return null;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class MemberInfo {
        private String name;
        private byte cByte;
        private byte[] userdata;
        private byte[] ttr;
        private Statistics statistics;

        public MemberInfo(byte[] bytes, int offset) {
            try {
                this.name = new String(bytes, offset, 8, "IBM-1047");
                this.name = this.name.trim();
            }
            catch (UnsupportedEncodingException ee) {
                throw new RuntimeException(ee);
            }
            this.ttr = new byte[3];
            for (int i = 0; i < this.ttr.length; ++i) {
                this.ttr[i] = bytes[offset + 8 + i];
            }
            this.cByte = bytes[offset + 11];
            int userDataLen = (this.cByte & 0x1F) * 2;
            this.userdata = new byte[userDataLen];
            for (int i = 0; i < userDataLen; ++i) {
                this.userdata[i] = bytes[offset + 12 + i];
            }
        }

        public String getName() {
            return this.name;
        }

        public boolean isAlias() {
            return (this.cByte & 0x80) != 0;
        }

        private int getSizeInBytes() {
            return 12 + this.userdata.length;
        }

        public byte[] getUserData() {
            return this.userdata;
        }

        public byte[] getTTR() {
            return this.ttr;
        }

        public Statistics getStatistics() {
            if (this.statistics == null) {
                try {
                    this.statistics = new Statistics();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            return this.statistics;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(this.name);
            if (this.isAlias()) {
                sb.append(" (A)");
            }
            if (this.getStatistics() != null) {
                sb.append(" ");
                sb.append(this.statistics.toString());
            }
            return sb.toString();
        }

        public class Statistics {
            public int version;
            public int mod;
            public byte flags;
            public Date creationDate;
            public Date modificationDate;
            public int currentLines;
            public int initialLines;
            public int modifiedLines;
            public String userid;

            public Statistics() throws RuntimeException {
                byte[] ud = MemberInfo.this.userdata;
                if (ud.length != 30) {
                    throw new IllegalStateException(Messages.getString("PdsDirectory.UserdataLenError"));
                }
                this.version = ByteUtil.bytesAsInt(ud, 0, 1);
                this.mod = ByteUtil.bytesAsInt(ud, 1, 1);
                this.flags = ud[2];
                Calendar cal = Calendar.getInstance();
                cal.clear();
                cal.set(1, this.unpackYear(ud, 4));
                cal.set(6, (int)ByteUtil.unpackLong(ud, 6, 2, true));
                this.creationDate = cal.getTime();
                cal.clear();
                cal.set(1, this.unpackYear(ud, 8));
                cal.set(6, (int)ByteUtil.unpackLong(ud, 10, 2, true));
                cal.set(11, (int)ByteUtil.unpackLong(ud, 12, 1, false));
                cal.set(12, (int)ByteUtil.unpackLong(ud, 13, 1, false));
                cal.set(13, (int)ByteUtil.unpackLong(ud, 3, 1, false));
                this.modificationDate = cal.getTime();
                this.currentLines = ByteUtil.bytesAsInt(ud, 14, 2);
                this.initialLines = ByteUtil.bytesAsInt(ud, 16, 2);
                this.modifiedLines = ByteUtil.bytesAsInt(ud, 18, 2);
                try {
                    this.userid = new String(ud, 20, 7, "IBM-1047");
                }
                catch (UnsupportedEncodingException ee) {
                    throw new RuntimeException(ee);
                }
            }

            private int unpackYear(byte[] ud, int offset) {
                int year = (int)ByteUtil.unpackLong(ud, offset, 2, false);
                return 1900 + year;
            }

            public String toString() {
                StringBuffer sb = new StringBuffer();
                sb.append(this.version);
                sb.append(".");
                sb.append(this.mod);
                sb.append(Messages.getString("PdsDirectory.Created"));
                sb.append(this.creationDate);
                sb.append(Messages.getString("PdsDirectory.LastModified"));
                sb.append(this.modificationDate);
                sb.append(Messages.getString("PdsDirectory.CurrentLines"));
                sb.append(this.currentLines);
                sb.append(Messages.getString("PdsDirectory.InitialLines"));
                sb.append(this.initialLines);
                sb.append(Messages.getString("PdsDirectory.ModifiedLines"));
                sb.append(this.modifiedLines);
                sb.append(Messages.getString("PdsDirectory.Userid"));
                sb.append(this.userid);
                return sb.toString();
            }
        }
    }
}

