/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos;

import com.ibm.jzos.Bsam;
import com.ibm.jzos.BsamRecordReader;
import com.ibm.jzos.ByteUtil;
import com.ibm.jzos.ZFileException;

class BsamVRecordReader
extends BsamRecordReader {
    protected int maxRecLen;
    protected byte[] block;
    protected int currentBlockLength;
    protected int currentOffset;
    protected boolean isBlocked;
    public static final int BDW_LEN = 4;
    public static final int RDW_LEN = 4;

    BsamVRecordReader(Bsam bsam) throws ZFileException {
        super(bsam);
        this.maxRecLen = bsam.getLrecl() - 4;
        this.block = new byte[bsam.getBlksize()];
        this.currentOffset = 4;
        this.currentBlockLength = 0;
        this.isBlocked = (this.getRecfmBits() & 8) == 8;
    }

    public synchronized int read(byte[] buf, int offset, int len) throws ZFileException {
        int remainingBlockLen = this.currentBlockLength - this.currentOffset;
        if (remainingBlockLen <= 0) {
            if (!this.readNextBlock()) {
                return -1;
            }
            remainingBlockLen = this.currentBlockLength - this.currentOffset;
        }
        if (remainingBlockLen < 4) {
            this.throwInvalidPartialRdwException();
        }
        int recLen = ByteUtil.bytesAsInt(this.block, this.currentOffset, 2);
        if ((recLen -= 4) < 0 || recLen > this.maxRecLen || recLen > remainingBlockLen - 4) {
            this.throwInvalidRdwException(recLen + 4);
        }
        this.currentOffset += 4;
        if (len > recLen) {
            len = recLen;
        }
        System.arraycopy(this.block, this.currentOffset, buf, offset, len);
        this.currentOffset += recLen;
        return len;
    }

    protected boolean readNextBlock() throws ZFileException {
        int bdwLen;
        this.currentOffset = 4;
        this.currentBlockLength = this.bsam.readBlock(this.block);
        if (this.currentBlockLength == -1) {
            return false;
        }
        if (this.currentBlockLength <= 4) {
            this.throwInvalidBlockLengthException(this.currentBlockLength);
        }
        if ((bdwLen = ByteUtil.bytesAsInt(this.block, 0, 2)) < 4 || bdwLen > this.currentBlockLength) {
            this.throwInvalidBdwException(bdwLen, this.currentBlockLength);
        }
        this.currentBlockLength = bdwLen;
        return true;
    }

    protected void throwInvalidBlockLengthException(int blockLen) throws ZFileException {
        throw this.bsam.newZFileException(" contains invalid block len: " + blockLen, 121);
    }

    protected void throwInvalidBdwException(int bdwLen, int blockLen) throws ZFileException {
        throw this.bsam.newZFileException(" contains invalid BDW: " + bdwLen + " with block len: " + blockLen, 121);
    }

    protected void throwInvalidRdwException(int recLen) throws ZFileException {
        throw this.bsam.newZFileException(" at offset=" + this.currentOffset + " contains invalid RDW: " + recLen, 121);
    }

    protected void throwInvalidPartialRdwException() throws ZFileException {
        throw this.bsam.newZFileException(" at offset=" + this.currentOffset + " contains invalid partial RDW", 121);
    }
}

