/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos;

import com.ibm.jzos.Bsam;
import com.ibm.jzos.BsamVRecordReader;
import com.ibm.jzos.ByteUtil;
import com.ibm.jzos.ZFileException;

class BsamVbsRecordReader
extends BsamVRecordReader {
    private byte[] record;
    private int partialRecordLength;
    public static final int SDW_LEN = 4;
    public static final byte SEGMENT_ONLY = 0;
    public static final byte SEGMENT_FIRST = 1;
    public static final byte SEGMENT_LAST = 2;
    public static final byte SEGMENT_MIDDLE = 3;

    BsamVbsRecordReader(Bsam bsam) throws ZFileException {
        super(bsam);
        this.record = new byte[this.maxRecLen];
        this.partialRecordLength = 0;
    }

    public synchronized int read(byte[] buf, int offset, int len) throws ZFileException {
        int recordLength = this.deblockSegmentsIntoRecord();
        if (recordLength == -1) {
            return -1;
        }
        if (len > recordLength) {
            len = recordLength;
        }
        System.arraycopy(this.record, 0, buf, offset, len);
        return len;
    }

    private int deblockSegmentsIntoRecord() throws ZFileException {
        int remainingBlockLen;
        block6: while ((remainingBlockLen = this.currentBlockLength - this.currentOffset) > 0 || this.readNextBlock()) {
            remainingBlockLen = this.currentBlockLength - this.currentOffset;
            if (remainingBlockLen < 4) {
                this.throwInvalidPartialSdwException();
            }
            int segLen = ByteUtil.bytesAsInt(this.block, this.currentOffset, 2);
            byte segControlCode = this.block[this.currentOffset + 2];
            if ((segLen -= 4) < 0 || segLen > remainingBlockLen - 4) {
                this.throwInvalidSdwException(segLen + 4);
            }
            if (this.partialRecordLength + segLen > this.maxRecLen) {
                this.throwInvalidRecordLengthException(this.partialRecordLength + segLen);
            }
            this.currentOffset += 4;
            System.arraycopy(this.block, this.currentOffset, this.record, this.partialRecordLength, segLen);
            this.partialRecordLength += segLen;
            this.currentOffset += segLen;
            switch (segControlCode) {
                case 0: {
                    if (this.partialRecordLength > segLen) {
                        this.throwSegmentCodeSequenceException();
                    }
                }
                case 2: {
                    int recordLength = this.partialRecordLength;
                    this.partialRecordLength = 0;
                    return recordLength;
                }
                case 1: {
                    if (this.partialRecordLength > segLen) {
                        this.throwSegmentCodeSequenceException();
                    }
                }
                case 3: {
                    continue block6;
                }
            }
            this.throwSegmentCodeException(segControlCode);
        }
        return -1;
    }

    private void throwInvalidPartialSdwException() throws ZFileException {
        throw this.bsam.newZFileException(" at offset=" + this.currentOffset + " contains invalid partial SDW", 121);
    }

    private void throwInvalidSdwException(int sdwLen) throws ZFileException {
        throw this.bsam.newZFileException(" at offset=" + this.currentOffset + " contains invalid SDW with length=" + sdwLen, 121);
    }

    private void throwInvalidRecordLengthException(int recLen) throws ZFileException {
        throw this.bsam.newZFileException(" at offset=" + this.currentOffset + " contains record length " + recLen + " larger than max len " + this.maxRecLen, 121);
    }

    private void throwSegmentCodeSequenceException() throws ZFileException {
        throw this.bsam.newZFileException(" at offset=" + this.currentOffset + " contains invalid sement control sequence", 121);
    }

    private void throwSegmentCodeException(byte segControlCode) throws ZFileException {
        throw this.bsam.newZFileException(" at offset=" + (this.currentOffset - 4) + " contains invalid segment control code " + Integer.toHexString(segControlCode), 121);
    }
}

