/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos;

import com.ibm.jzos.Bsam;
import com.ibm.jzos.BsamVbRecordWriter;
import com.ibm.jzos.ZFileException;

class BsamVbsRecordWriter
extends BsamVbRecordWriter {
    private static final short SEG_FIRST = 256;
    private static final short SEG_LAST = 512;
    private static final short SEG_MIDDLE = 768;
    public static final int SDW_LEN = 4;

    BsamVbsRecordWriter(Bsam bsam) throws ZFileException {
        super(bsam);
        this.lrecl = bsam.getLrecl();
        this.block = new byte[bsam.getBlksize()];
        this.blockOffset = 4;
    }

    public synchronized void write(byte[] buf, int offset, int len) throws ZFileException {
        if (this.blockOffset + 4 + 1 > this.block.length) {
            this.writeBlock();
        }
        if (this.blockOffset + len + 4 <= this.block.length) {
            this.writeRecord(buf, offset, len);
        } else {
            int capacity;
            int segType = 256;
            while ((capacity = this.block.length - 4 - this.blockOffset) < len) {
                this.writeSegment(buf, offset, capacity, (short)segType);
                this.writeBlock();
                segType = 768;
                len -= capacity;
                offset += capacity;
            }
            this.writeSegment(buf, offset, len, (short)512);
        }
    }

    private void writeSegment(byte[] buf, int offset, int len, short segType) {
        this.putSDW(len, segType, this.block, this.blockOffset);
        this.blockOffset += 4;
        System.arraycopy(buf, offset, this.block, this.blockOffset, len);
        this.blockOffset += len;
    }

    private void putSDW(int length, int segType, byte[] bytes, int offset) {
        if ((length += 4) > this.lrecl) {
            throw new IllegalArgumentException("Record length " + (length - 4) + " is too big for LRECL " + this.lrecl);
        }
        bytes[offset] = (byte)(length >>> 8 & 0xFF);
        bytes[offset + 1] = (byte)(length & 0xFF);
        bytes[offset + 2] = (byte)(segType >>> 8 & 0xFF);
        bytes[offset + 3] = (byte)(segType & 0xFF);
    }
}

