/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos;

import com.ibm.jzos.ByteUtil;
import com.ibm.jzos.ZUtil;
import java.io.UnsupportedEncodingException;

public class DatasetVolumeList {
    public static final int BUF_LEN = 309;
    public static final int MAX_ENTRIES = 20;
    private byte[] bytes = new byte[309];

    public byte[] getBytes() {
        return this.bytes;
    }

    public int getTotalVolumesCount() {
        return ((this.bytes[0] & 0xFF) << 8) + (this.bytes[1] & 0xFF);
    }

    public int[] getDeviceTypes() {
        int volCount = this.getTotalVolumesCount();
        if (volCount > 20) {
            volCount = 20;
        }
        int[] deviceTypes = new int[volCount];
        int j = 2;
        for (int i = 0; i < volCount; ++i) {
            deviceTypes[i] = ByteUtil.bytesAsInt(this.bytes, j, 4);
            j += 12;
        }
        return deviceTypes;
    }

    public String[] getVolumes() {
        int volCount = this.getTotalVolumesCount();
        if (volCount > 20) {
            volCount = 20;
        }
        String[] volumes = new String[volCount];
        String encoding = ZUtil.getDefaultPlatformEncoding();
        int j = 2;
        for (int i = 0; i < volCount; ++i) {
            try {
                String volser = new String(this.bytes, j + 4, 6, encoding);
                volumes[i] = volser.trim();
            }
            catch (UnsupportedEncodingException uce) {
                throw new RuntimeException(uce.toString());
            }
            j += 12;
        }
        return volumes;
    }

    public String getReturnedDSN() {
        try {
            String encoding = ZUtil.getDefaultPlatformEncoding();
            String dsn = new String(this.bytes, 265, 44, encoding);
            return dsn.trim();
        }
        catch (UnsupportedEncodingException uce) {
            throw new RuntimeException(uce.toString());
        }
    }
}

