/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos;

import com.ibm.jzos.JesVsam;
import com.ibm.jzos.JesVsamException;
import com.ibm.jzos.RcException;
import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZUtil;
import java.io.IOException;

public class MvsJobSubmitter {
    public static final int DEFAULT_RDR_LRECL = 80;
    public static final boolean DEFAULT_RDR_FIXED_RECFM = true;
    public static final char DEFAULT_RDR_CLASS = '*';
    private int rdrLrecl = 80;
    private boolean rdrFixedRecfm = true;
    private char rdrClass = (char)42;
    String internalReaderDD = null;
    JesVsam internalReader = null;
    byte[] rbar = null;

    public MvsJobSubmitter() throws IOException {
        this.openInternalReader();
    }

    public MvsJobSubmitter(int rdrLrecl, boolean rdrIsFixedRecfm, char rdrClass) throws IOException {
        this.rdrFixedRecfm = rdrIsFixedRecfm;
        this.rdrLrecl = rdrLrecl;
        this.rdrClass = rdrClass;
        this.openInternalReader();
    }

    public char getRdrClass() {
        return this.rdrClass;
    }

    public int getRdrLrecl() {
        return this.rdrLrecl;
    }

    public boolean isRdrFixedRecfm() {
        return this.rdrFixedRecfm;
    }

    public void write(String line) throws IOException {
        this.write(line.getBytes(ZUtil.getDefaultPlatformEncoding()));
    }

    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    public void write(byte[] bytes, int offset, int length) throws IOException {
        if (this.internalReader == null) {
            throw new IllegalStateException("Internal reader is not open");
        }
        this.internalReader.write(bytes, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.internalReader == null) {
            throw new IllegalStateException("Internal reader is not open");
        }
        try {
            this.rbar = this.internalReader.close();
        }
        finally {
            this.internalReader = null;
        }
        try {
            ZFile.bpxwdyn("free fi(" + this.internalReaderDD + ") msg(2)");
        }
        catch (RcException rce) {
            throw new JesVsamException(1, rce.getRc(), 0, "Error freeing internal reader, BPXWDYN rc=" + rce.getRc());
        }
        finally {
            this.internalReaderDD = null;
        }
    }

    public String getJobid() throws IOException {
        String jobid;
        if (this.internalReader != null) {
            this.close();
        }
        if ((jobid = new String(this.rbar, ZUtil.getDefaultPlatformEncoding()).trim()).length() == 0) {
            throw new IOException("No job was created; jobid was not found");
        }
        return jobid;
    }

    private void openInternalReader() throws IOException {
        this.allocInternalReader();
        this.internalReader = new JesVsam(this.internalReaderDD, true);
        this.internalReader.setLrecl(this.rdrLrecl);
    }

    private void allocInternalReader() throws IOException {
        try {
            this.internalReaderDD = ZFile.allocDummyDDName();
            String sysoutArg = this.rdrClass == '*' ? "" : "(" + this.rdrClass + ")";
            String cmd = "alloc fi(" + this.internalReaderDD + ") sysout" + sysoutArg + " writer(intrdr)" + " recfm(" + (this.rdrFixedRecfm ? "F" : "V") + ") " + " lrecl(" + this.rdrLrecl + ")  reuse msg(2)";
            ZFile.bpxwdyn(cmd);
        }
        catch (RcException rce) {
            throw new JesVsamException(1, rce.getRc(), 0, "Error allocating internal reader, BPXWDYN rc=" + rce.getRc());
        }
    }
}

