/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.fields;

import com.ibm.jzos.fields.BigDecimalAccessor;
import com.ibm.jzos.fields.ExternalDecimalAsBigIntegerField;
import java.math.BigDecimal;

public class ExternalDecimalAsBigDecimalField
implements BigDecimalAccessor {
    private ExternalDecimalAsBigIntegerField biConverter;
    private int scale;

    public ExternalDecimalAsBigDecimalField(int offset, int precision, int scale, boolean signed, boolean signTrailing, boolean signExternal, boolean blankWhenZero) {
        if (scale < 0) {
            throw new IllegalArgumentException("scale must be >= 0");
        }
        this.biConverter = new ExternalDecimalAsBigIntegerField(offset, precision, 0, signed, signTrailing, signExternal, blankWhenZero);
        this.scale = scale;
    }

    public int getByteLength() {
        return this.biConverter.getByteLength();
    }

    public int getOffset() {
        return this.biConverter.getOffset();
    }

    public void setOffset(int offset) {
        this.biConverter.setOffset(offset);
    }

    public int getPrecision() {
        return this.biConverter.getPrecision();
    }

    public boolean isSigned() {
        return this.biConverter.isSigned();
    }

    public boolean isSignExternal() {
        return this.biConverter.isSignExternal();
    }

    public boolean isSignTrailing() {
        return this.biConverter.isSignTrailing();
    }

    public boolean isBlankWhenZero() {
        return this.biConverter.isBlankWhenZero();
    }

    public BigDecimal getBigDecimal(byte[] buffer) {
        return this.getBigDecimal(buffer, 0);
    }

    public BigDecimal getBigDecimal(byte[] buffer, int bufOffset) {
        return new BigDecimal(this.biConverter.getBigInteger(buffer, bufOffset), this.scale);
    }

    public void putBigDecimal(BigDecimal value, byte[] buffer) throws IllegalArgumentException {
        this.putBigDecimal(value, buffer, 0);
    }

    public void putBigDecimal(BigDecimal value, byte[] buffer, int bufOffset) throws IllegalArgumentException {
        BigDecimal bd = value.setScale(this.scale, 1);
        this.biConverter.putBigInteger(bd.unscaledValue(), buffer, bufOffset);
    }

    public boolean equals(BigDecimal a, BigDecimal b) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return false;
        }
        return a.equals(b);
    }

    public int getScale() {
        return this.scale;
    }
}

