/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.fields;

import com.ibm.jzos.fields.DoubleAccessor;

public class ExternalFloatField
implements DoubleAccessor {
    private static final byte EBCDIC_MINUS = 96;
    private static final byte EBCDIC_PLUS = 78;
    private static final byte EBCDIC_SPACE = 64;
    private static final byte EBCDIC_E = -59;
    private static final byte EBCDIC_DOT = 75;
    private static final byte EBCDIC_0 = -16;
    private static final byte EBCDIC_1 = -15;
    private static final byte EBCDIC_2 = -14;
    private static final byte EBCDIC_3 = -13;
    private static final byte EBCDIC_4 = -12;
    private static final byte EBCDIC_5 = -11;
    private static final byte EBCDIC_6 = -10;
    private static final byte EBCDIC_7 = -9;
    private static final byte EBCDIC_8 = -8;
    private static final byte EBCDIC_9 = -7;
    private static final String NORMALIZED_ZERO = "0.0E0";
    private boolean showMantissaPlusSign;
    private boolean showExponentPlusSign;
    private boolean impliedDecimal;
    private int scale;
    private int precision;
    private int length;
    private int offset;

    public ExternalFloatField(int offset, int precision, int scale, boolean mantSign, boolean expSign, boolean impliedDecimal) {
        this.offset = offset;
        this.precision = precision;
        this.scale = scale;
        if (precision < 1 || precision > 18) {
            throw new IllegalArgumentException("precision");
        }
        if (scale < 0 || scale > precision) {
            throw new IllegalStateException("scale");
        }
        this.showMantissaPlusSign = mantSign;
        this.showExponentPlusSign = expSign;
        this.impliedDecimal = impliedDecimal;
        this.length = 1 + precision + (impliedDecimal ? 0 : 1) + 4;
    }

    public double getDouble(byte[] buffer) {
        return this.getDouble(buffer, 0);
    }

    public double getDouble(byte[] buffer, int bufOffset) {
        int off = this.offset + bufOffset;
        StringBuffer sb = new StringBuffer();
        if (this.isNegative(buffer[off++])) {
            sb.append("-");
        }
        sb.append(this.getDigitAsChar(buffer[off++]));
        sb.append('.');
        for (int i = this.precision - 1 + (this.impliedDecimal ? 0 : 1); i > 0; --i) {
            byte b;
            if ((b = buffer[off++]) == 75) {
                if (!this.impliedDecimal) continue;
                throw new IllegalStateException("Unexpected decimal point");
            }
            sb.append(this.getDigitAsChar(b));
        }
        if (buffer[off++] != -59) {
            throw new IllegalStateException("Missing exponent designator");
        }
        sb.append('e');
        boolean negExp = this.isNegative(buffer[off++]);
        int exp = (buffer[off++] & 0xF) * 10 + (buffer[off++] & 0xF);
        if (negExp) {
            exp *= -1;
        }
        if (this.precision == this.scale) {
            --exp;
        } else {
            for (int i = this.precision - this.scale; i > 1; --i) {
                ++exp;
            }
        }
        sb.append(exp);
        sb.append('d');
        String s = sb.toString();
        return Double.parseDouble(s);
    }

    public void putDouble(double value, byte[] buffer) {
        this.putDouble(value, buffer, 0);
    }

    public void putDouble(double value, byte[] buffer, int bufOffset) {
        String s;
        int off = this.offset + bufOffset;
        if (Double.isInfinite(value)) {
            throw new IllegalArgumentException("infinity");
        }
        if (Double.isNaN(value)) {
            throw new IllegalArgumentException("NaN");
        }
        boolean isNegative = value < 0.0;
        value = Math.abs(value);
        int expBias = 0;
        if (value == 0.0) {
            s = NORMALIZED_ZERO;
        } else {
            if (value < 1000000.0 && value > 0.001) {
                expBias = 10;
                value *= 1.0E10;
            }
            s = Double.toString(value);
        }
        buffer[off++] = isNegative ? 96 : (this.showMantissaPlusSign ? 78 : 64);
        int expShift = value == 0.0 ? 0 : 1 - (this.precision - this.scale);
        byte[] decimal = this.getDecimalBytes(s);
        System.arraycopy(decimal, 0, buffer, off, decimal.length);
        off += decimal.length;
        buffer[off++] = -59;
        int exp = Integer.parseInt(s.substring(s.indexOf(69) + 1));
        buffer[off++] = (exp += expShift - expBias) < 0 ? 96 : (this.showExponentPlusSign ? 78 : 64);
        String expStr = Integer.toString(Math.abs(exp));
        char c = expStr.charAt(0);
        buffer[off++] = expStr.length() == 1 ? -16 : (int)this.getCharAsEbcdicByte(expStr.charAt(0));
        c = expStr.charAt(expStr.length() - 1);
        buffer[off] = this.getCharAsEbcdicByte(c);
    }

    public int getByteLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    private char getDigitAsChar(byte b) {
        switch (b) {
            case -16: {
                return '0';
            }
            case -15: {
                return '1';
            }
            case -14: {
                return '2';
            }
            case -13: {
                return '3';
            }
            case -12: {
                return '4';
            }
            case -11: {
                return '5';
            }
            case -10: {
                return '6';
            }
            case -9: {
                return '7';
            }
            case -8: {
                return '8';
            }
            case -7: {
                return '9';
            }
        }
        throw new IllegalStateException("Bad decimal digit");
    }

    private byte getCharAsEbcdicByte(char c) {
        switch (c) {
            case '0': {
                return -16;
            }
            case '1': {
                return -15;
            }
            case '2': {
                return -14;
            }
            case '3': {
                return -13;
            }
            case '4': {
                return -12;
            }
            case '5': {
                return -11;
            }
            case '6': {
                return -10;
            }
            case '7': {
                return -9;
            }
            case '8': {
                return -8;
            }
            case '9': {
                return -7;
            }
            case '.': {
                return 75;
            }
            case 'E': {
                return -59;
            }
        }
        throw new IllegalStateException("Bad mantissa char");
    }

    private boolean isNegative(byte b) {
        switch (b) {
            case 96: {
                return true;
            }
            case 78: {
                if (!this.showMantissaPlusSign) {
                    throw new IllegalStateException("Unexpected mantissa or exponent plus sign");
                }
                return false;
            }
            case 64: {
                if (this.showMantissaPlusSign) {
                    throw new IllegalStateException("Missing expected mantissa or exponent plus sign");
                }
                return false;
            }
        }
        throw new IllegalStateException("Bad mantissa or exponent sign");
    }

    private byte[] getDecimalBytes(String s) {
        byte[] bytes = new byte[this.precision + (this.impliedDecimal ? 0 : 1)];
        int pointIdx = this.precision - this.scale;
        if (!this.impliedDecimal) {
            bytes[pointIdx] = 75;
        }
        int off = 0;
        int i = 0;
        while (off < bytes.length) {
            if (!this.impliedDecimal && off == pointIdx) {
                ++off;
                continue;
            }
            byte b = this.getCharAsEbcdicByte(s.charAt(i));
            if (b == -59) break;
            if (b == 75) {
                b = this.getCharAsEbcdicByte(s.charAt(++i));
            }
            bytes[off++] = b;
            ++i;
        }
        while (off < bytes.length) {
            if (off != pointIdx) {
                bytes[off] = -16;
            }
            ++off;
        }
        return bytes;
    }

    public boolean equals(Double aDouble, double adouble) {
        if (aDouble == null) {
            return false;
        }
        return aDouble == adouble;
    }

    public boolean isImpliedDecimal() {
        return this.impliedDecimal;
    }

    public int getLength() {
        return this.length;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public boolean isShowExponentPlusSign() {
        return this.showExponentPlusSign;
    }

    public boolean isShowMantissaPlusSign() {
        return this.showMantissaPlusSign;
    }
}

