/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.ibm.jzos.FileFactory;
import com.ibm.jzos.ZFile;
import com.ibm.urbancode.zos.ispf.gateway.common.IspfGatewayExecutor;
import com.ibm.urbancode.zos.ispf.gateway.common.IspfGatewayXMLInput;
import com.ibm.urbancode.zos.ispf.gateway.common.IspfGatewayXMLResponse;
import com.ibm.urbancode.zos.ispf.gateway.common.ServiceType;
import com.urbancode.air.plugin.command.helpers.TempDatasetHelper;
import com.urbancode.air.plugin.command.helpers.TempIspfFileHelper;
import com.urbancode.air.plugin.command.inputs.PluginInputs;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Properties;

public class RexxExecutor {
    private static final String TSO_EXEC = "TSO EXEC '";
    private static final String SINGLE_QUOTE = "'";
    private final Properties inputProperties;
    private final Properties outputProperties;
    private static final int ERROR_CODE = 8;

    public RexxExecutor(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() {
        int exitCode = 0;
        TempDatasetHelper tempDatasetHelper = null;
        try {
            PluginInputs pluginInputs = PluginInputs.getValidatedInputs(this.inputProperties);
            tempDatasetHelper = new TempDatasetHelper(pluginInputs.getDsnPrefix(), pluginInputs.getSourceType(), pluginInputs.getSourceValue(), pluginInputs.getRexxArguments());
            tempDatasetHelper.setupDatasets();
            TempIspfFileHelper tempIspfFileHelper = new TempIspfFileHelper(tempDatasetHelper.getTempPDS(), pluginInputs.getSysprocDatasets(), pluginInputs.getDsnPrefix());
            tempIspfFileHelper.setUpIspf();
            IspfGatewayXMLInput ispfGatewayXMLInput = new IspfGatewayXMLInput(ServiceType.ISPF, TSO_EXEC + tempDatasetHelper.getDriverProgramDataset() + SINGLE_QUOTE);
            IspfGatewayExecutor ispfGatewayExecutor = new IspfGatewayExecutor(pluginInputs.getIspfGatewayPath(), pluginInputs.getDsnPrefix());
            ispfGatewayExecutor.prependDirectoryToPATH(tempIspfFileHelper.getTemporaryIspfDirectory());
            long startTime = System.currentTimeMillis();
            IspfGatewayXMLResponse ispfGatewayXMLResponse = ispfGatewayExecutor.execute(ispfGatewayXMLInput);
            double seconds = (double)(System.currentTimeMillis() - startTime) / 1000.0;
            if (ispfGatewayXMLResponse.getOutputText().isPresent()) {
                System.out.println(ispfGatewayXMLResponse.getOutputText().get());
                System.out.println("Elapsed time: " + seconds + " seconds.");
            } else {
                this.printIspfGatewayResponse(ispfGatewayXMLResponse);
            }
            this.outputProperties.setProperty("RexxReturnCode", String.valueOf(ispfGatewayXMLResponse.getReturnCode()));
            if (ispfGatewayXMLResponse.getReturnCode() != 0) {
                int n = 8;
                return n;
            }
            this.setOutputPropertiesFromDataset(tempDatasetHelper.getOutputPropertiesDataset());
        }
        catch (RuntimeException runtimeException) {
            System.out.println(runtimeException.getMessage());
            exitCode = 8;
        }
        catch (Exception e) {
            e.printStackTrace();
            exitCode = 8;
        }
        finally {
            try {
                if (tempDatasetHelper != null) {
                    tempDatasetHelper.deleteTemporaryDatasets();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                exitCode = 8;
            }
        }
        return exitCode;
    }

    private void printIspfGatewayResponse(IspfGatewayXMLResponse ispfGatewayXMLResponse) {
        System.out.println("\n\nISPF Gateway Operation log:");
        System.out.println(ispfGatewayXMLResponse.getOperationsLog());
        System.out.println("\n\nISPF Gateway Reason Codes:");
        for (String reasonCode : ispfGatewayXMLResponse.getReasonCodeList()) {
            System.out.println(reasonCode);
        }
        System.out.println("\n\nISPF Gateway Return Code: " + ispfGatewayXMLResponse.getReturnCode());
    }

    private void setOutputPropertiesFromDataset(String rexxOutputPropertiesDataset) throws IOException {
        try (BufferedReader factoryReader = FileFactory.newBufferedReader(ZFile.getSlashSlashQuotedDSN(rexxOutputPropertiesDataset, true));){
            this.outputProperties.load(factoryReader);
        }
    }
}

