/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos;

import com.ibm.jzos.Messages;
import com.ibm.jzos.RecordReader;
import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZFileConstants;
import com.ibm.jzos.ZFileException;
import com.ibm.jzos.ZFileFixedRecordReader;
import com.ibm.jzos.ZFileVariableRecordReader;
import com.ibm.jzos.ZFileVariableSpannedRecordReader;

public class ZFileRecordReader
extends RecordReader
implements ZFileConstants {
    protected ZFile zFile;
    private String ddname;
    private int blksize;
    private int lrecl;
    private int recfmBits;
    private String recfm;
    private String dsn;

    protected ZFileRecordReader(ZFile zFile) throws ZFileException {
        this.zFile = zFile;
        this.blksize = zFile.getBlksize();
        this.lrecl = zFile.getLrecl();
        this.recfmBits = zFile.getRecfmBits();
        this.recfm = zFile.getRecfm();
        this.dsn = zFile.getActualFilename();
    }

    ZFileRecordReader(String ddname) throws ZFileException {
        this(new ZFile("//DD:" + ddname, "rb,type=record,noseek"));
        this.ddname = ddname;
    }

    @Deprecated
    public static ZFileRecordReader newReader(ZFile zFile) throws ZFileException {
        if (zFile.getOpenMode() != 2) {
            throw new IllegalArgumentException(Messages.getString("ZFileRecordReader.MustBeRecordMode"));
        }
        if (zFile.getModeFlags() != 1) {
            throw new IllegalArgumentException(Messages.getString("ZFileRecordReader.MustBeReadMode"));
        }
        if ((zFile.getRecfmBits() & 8) == 0) {
            return new ZFileRecordReader(zFile);
        }
        if ((zFile.getRecfmBits() & 1) == 1) {
            return new ZFileFixedRecordReader(zFile);
        }
        if ((zFile.getRecfmBits() & 2) == 2) {
            if ((zFile.getRecfmBits() & 0x10) == 16) {
                String zFileName = zFile.getFilename();
                String zFileOptions = zFile.getOptions();
                try {
                    return new ZFileVariableSpannedRecordReader(zFile);
                }
                catch (ZFileException zfe) {
                    if (zfe.getErrno2() == -1073020654) {
                        try {
                            zFile.close();
                        }
                        catch (Exception ignore) {
                            // empty catch block
                        }
                        zFile = new ZFile(zFileName, zFileOptions);
                        return new ZFileRecordReader(zFile);
                    }
                    throw zfe;
                }
            }
            return new ZFileVariableRecordReader(zFile);
        }
        throw new IllegalArgumentException(Messages.getString("ZFileRecordReader.RecfmNotSupported"));
    }

    public int read(byte[] buf) throws ZFileException {
        return this.zFile.read(buf, 0, buf.length);
    }

    public int read(byte[] buf, int offset, int len) throws ZFileException {
        return this.zFile.read(buf, offset, len);
    }

    public void close() throws ZFileException {
        this.zFile.close();
        this.doAutoFree();
    }

    public int getBlksize() {
        return this.blksize;
    }

    public String getDDName() {
        return this.ddname;
    }

    public String getDsn() {
        return this.dsn;
    }

    public int getLrecl() {
        return this.lrecl;
    }

    public String getRecfm() {
        return this.recfm;
    }

    public int getRecfmBits() {
        return this.recfmBits;
    }

    protected String mutateOptionsToRecfmU(String options) {
        int inoseek;
        int start = (options = options.toLowerCase().trim()).indexOf(",recfm=");
        if (start >= 0) {
            int end = options.indexOf(44, start + 1);
            options = end < 0 ? options.substring(0, start) : options.substring(0, start) + options.substring(end);
        }
        options = (inoseek = options.indexOf(",noseek")) < 0 ? options + ",recfm=u,noseek" : options + ",recfm=u";
        return options;
    }
}

